/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.commons.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MultiThreadingUtil {
    private MultiThreadingUtil() {
    }

    public static <T> List<T> runActionsParallel(List<Callable<T>> actions, int numberOfThreads) {
        int amountOfThreads = Math.max(Math.min(numberOfThreads, Runtime.getRuntime().availableProcessors()), 1);
        ExecutorService service = Executors.newFixedThreadPool(amountOfThreads);
        try {
            ArrayList<T> results = new ArrayList<T>();
            List<Future<T>> f = service.invokeAll(actions);
            for (Future<T> tFuture : f) {
                try {
                    T future = tFuture.get();
                    if (future == null) continue;
                    results.add(future);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while executing action in parallel", e);
                }
            }
            ArrayList<T> arrayList = results;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread was interrupted while executing actions in parallel", e);
        }
        finally {
            service.shutdown();
        }
    }
}

