/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.css.resolve.CssContext;
import com.itextpdf.html2pdf.css.resolve.func.counter.CssCounterManager;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.Map;

public class CounterProcessorUtil {
    public static void processCounters(Map<String, String> cssProps, CssContext context) {
        String counterReset = cssProps.get("counter-reset");
        CounterProcessorUtil.processReset(counterReset, context);
        String counterIncrement = cssProps.get("counter-increment");
        CounterProcessorUtil.processIncrement(counterIncrement, context);
    }

    public static void startProcessingCounters(CssContext context, IElementNode element) {
        CssCounterManager counterManager = context.getCounterManager();
        counterManager.pushEveryCounterToCounters(element);
    }

    public static void endProcessingCounters(CssContext context, IElementNode element) {
        CssCounterManager counterManager = context.getCounterManager();
        counterManager.popEveryCounterFromCounters(element);
    }

    private static void processReset(String counterReset, CssContext context) {
        if (counterReset != null) {
            CssCounterManager counterManager = context.getCounterManager();
            String[] params = counterReset.split(" ");
            for (int i = 0; i < params.length; ++i) {
                Integer possibleCounterValue;
                String counterName = params[i];
                if (i + 1 < params.length && (possibleCounterValue = CssDimensionParsingUtils.parseInteger((String)params[i + 1])) != null) {
                    counterManager.resetCounter(counterName, possibleCounterValue);
                    ++i;
                    continue;
                }
                counterManager.resetCounter(counterName);
            }
        }
    }

    private static void processIncrement(String counterIncrement, CssContext context) {
        if (counterIncrement != null) {
            CssCounterManager counterManager = context.getCounterManager();
            String[] params = counterIncrement.split(" ");
            for (int i = 0; i < params.length; ++i) {
                Integer possibleIncrementValue;
                String counterName = params[i];
                if (i + 1 < params.length && (possibleIncrementValue = CssDimensionParsingUtils.parseInteger((String)params[i + 1])) != null) {
                    counterManager.incrementCounter(counterName, possibleIncrementValue);
                    ++i;
                    continue;
                }
                counterManager.incrementCounter(counterName);
            }
        }
    }
}

