/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.ContextMappingHelper;
import com.itextpdf.html2pdf.util.SvgProcessingUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.DefaultSvgProcessor;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgTagWorker
implements ITagWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgTagWorker.class);
    private Image svgImage = null;
    private ISvgProcessorResult processingResult;

    public SvgTagWorker(IElementNode element, ProcessorContext context) {
        SvgConverterProperties props = ContextMappingHelper.mapToSvgConverterProperties(context);
        try {
            this.processingResult = new DefaultSvgProcessor().process((INode)element, (ISvgConverterProperties)props);
        }
        catch (SvgProcessingException spe) {
            LOGGER.error("Unable to process an SVG element", (Throwable)spe);
        }
        context.startProcessingInlineSvg();
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (this.processingResult != null) {
            SvgProcessingUtil util = new SvgProcessingUtil(context.getResourceResolver());
            this.svgImage = util.createSvgImageFromProcessingResult(this.processingResult);
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.svgImage, element);
            context.endProcessingInlineSvg();
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.svgImage;
    }
}

