/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.TdTagWorker;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThTagWorker
extends TdTagWorker {
    public ThTagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        super.processEnd(element, context);
        IPropertyContainer elementResult = super.getElementResult();
        if (elementResult instanceof IAccessibleElement) {
            ((IAccessibleElement)elementResult).getAccessibilityProperties().setRole("TH");
            if (context.getPdfDocument() == null || context.getPdfDocument().isTagged()) {
                String scope = element.getAttribute("scope");
                AccessibilityProperties properties = ((IAccessibleElement)elementResult).getAccessibilityProperties();
                PdfDictionary attributes = new PdfDictionary();
                attributes.put(PdfName.O, (PdfObject)PdfName.Table);
                if (scope != null && ("row".equalsIgnoreCase(scope) || "rowgroup".equalsIgnoreCase(scope))) {
                    attributes.put(PdfName.Scope, (PdfObject)PdfName.Row);
                    properties.addAttributes(new PdfStructureAttributes(attributes));
                } else if (scope != null && ("col".equalsIgnoreCase(scope) || "colgroup".equalsIgnoreCase(scope))) {
                    attributes.put(PdfName.Scope, (PdfObject)PdfName.Column);
                    properties.addAttributes(new PdfStructureAttributes(attributes));
                } else {
                    Logger logger = LoggerFactory.getLogger(ThTagWorker.class);
                    logger.warn(MessageFormatUtil.format((String)"Not supported th scope type: {0}. Document may not be compliant with PDF/UA standards.", (Object[])new Object[]{scope}));
                }
            }
        }
    }
}

