/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityPropertiesToStructElem;
import com.itextpdf.kernel.pdf.tagutils.BackedAccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.TagReference;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagTreePointer {
    private static final String MCR_MARKER = "MCR";
    private TagStructureContext tagStructureContext;
    private PdfStructElem currentStructElem;
    private PdfPage currentPage;
    private PdfStream contentStream;
    private PdfNamespace currentNamespace;
    private int nextNewKidIndex = -1;

    public TagTreePointer(PdfDocument document) {
        this.tagStructureContext = document.getTagStructureContext();
        this.setCurrentStructElem(this.tagStructureContext.getRootTag());
        this.setNamespaceForNewTags(this.tagStructureContext.getDocumentDefaultNamespace());
    }

    public TagTreePointer(TagTreePointer tagPointer) {
        this.tagStructureContext = tagPointer.tagStructureContext;
        this.setCurrentStructElem(tagPointer.getCurrentStructElem());
        this.currentPage = tagPointer.currentPage;
        this.contentStream = tagPointer.contentStream;
        this.currentNamespace = tagPointer.currentNamespace;
    }

    TagTreePointer(PdfStructElem structElem, PdfDocument document) {
        this.tagStructureContext = document.getTagStructureContext();
        this.setCurrentStructElem(structElem);
    }

    public TagTreePointer setPageForTagging(PdfPage page) {
        if (page.isFlushed()) {
            throw new PdfException("The page has been already flushed.");
        }
        this.currentPage = page;
        return this;
    }

    public PdfPage getCurrentPage() {
        return this.currentPage;
    }

    public TagTreePointer setContentStreamForTagging(PdfStream contentStream) {
        this.contentStream = contentStream;
        return this;
    }

    public PdfStream getCurrentContentStream() {
        return this.contentStream;
    }

    public TagStructureContext getContext() {
        return this.tagStructureContext;
    }

    public PdfDocument getDocument() {
        return this.tagStructureContext.getDocument();
    }

    public TagTreePointer setNamespaceForNewTags(PdfNamespace namespace) {
        this.currentNamespace = namespace;
        return this;
    }

    public PdfNamespace getNamespaceForNewTags() {
        return this.currentNamespace;
    }

    public TagTreePointer addTag(String role) {
        this.addTag(-1, role);
        return this;
    }

    public TagTreePointer addTag(int index, String role) {
        this.tagStructureContext.throwExceptionIfRoleIsInvalid(role, this.currentNamespace);
        this.setNextNewKidIndex(index);
        this.setCurrentStructElem(this.addNewKid(role));
        return this;
    }

    public TagTreePointer addTag(AccessibilityProperties properties) {
        this.addTag(-1, properties);
        return this;
    }

    public TagTreePointer addTag(int index, AccessibilityProperties properties) {
        this.tagStructureContext.throwExceptionIfRoleIsInvalid(properties, this.currentNamespace);
        this.setNextNewKidIndex(index);
        this.setCurrentStructElem(this.addNewKid(properties));
        return this;
    }

    public TagTreePointer addAnnotationTag(PdfAnnotation annotation) {
        this.throwExceptionIfCurrentPageIsNotInited();
        PdfObjRef kid = new PdfObjRef(annotation, this.getCurrentStructElem(), this.getDocument().getNextStructParentIndex());
        if (!this.ensureElementPageEqualsKidPage(this.getCurrentStructElem(), (PdfDictionary)this.currentPage.getPdfObject())) {
            ((PdfDictionary)kid.getPdfObject()).put(PdfName.Pg, ((PdfDictionary)this.currentPage.getPdfObject()).getIndirectReference());
        }
        this.addNewKid(kid);
        return this;
    }

    public TagTreePointer setNextNewKidIndex(int nextNewKidIndex) {
        if (nextNewKidIndex > -1) {
            this.nextNewKidIndex = nextNewKidIndex;
        }
        return this;
    }

    public TagTreePointer removeTag() {
        PdfStructElem currentStructElem = this.getCurrentStructElem();
        IStructureNode parentElem = currentStructElem.getParent();
        if (parentElem instanceof PdfStructTreeRoot) {
            throw new PdfException("Cannot remove document root tag.");
        }
        List<IStructureNode> kids = currentStructElem.getKids();
        PdfStructElem parent = (PdfStructElem)parentElem;
        if (parent.isFlushed()) {
            throw new PdfException("Cannot remove tag, because its parent is flushed.");
        }
        Object objForStructDict = this.tagStructureContext.getWaitingTagsManager().getObjForStructDict((PdfDictionary)currentStructElem.getPdfObject());
        this.tagStructureContext.getWaitingTagsManager().removeWaitingState(objForStructDict);
        int removedKidIndex = parent.removeKid(currentStructElem);
        PdfIndirectReference indRef = ((PdfDictionary)currentStructElem.getPdfObject()).getIndirectReference();
        if (indRef != null) {
            indRef.setFree();
        }
        for (IStructureNode kid : kids) {
            if (kid instanceof PdfStructElem) {
                parent.addKid(removedKidIndex++, (PdfStructElem)kid);
                continue;
            }
            PdfMcr mcr = this.prepareMcrForMovingToNewParent((PdfMcr)kid, parent);
            parent.addKid(removedKidIndex++, mcr);
        }
        ((PdfDictionary)currentStructElem.getPdfObject()).clear();
        this.setCurrentStructElem(parent);
        return this;
    }

    public TagTreePointer relocateKid(int kidIndex, TagTreePointer pointerToNewParent) {
        if (this.getDocument() != pointerToNewParent.getDocument()) {
            throw new PdfException("Tag cannot be moved to the another document's tag structure.");
        }
        if (this.getCurrentStructElem().isFlushed()) {
            throw new PdfException("Cannot relocate tag which parent is already flushed.");
        }
        if (this.isPointingToSameTag(pointerToNewParent)) {
            if (kidIndex == pointerToNewParent.nextNewKidIndex) {
                return this;
            }
            if (kidIndex < pointerToNewParent.nextNewKidIndex) {
                pointerToNewParent.setNextNewKidIndex(pointerToNewParent.nextNewKidIndex - 1);
            }
        }
        if (this.getCurrentStructElem().getKids().get(kidIndex) == null) {
            throw new PdfException("Cannot relocate tag which is already flushed.");
        }
        IStructureNode removedKid = this.getCurrentStructElem().removeKid(kidIndex, true);
        if (removedKid instanceof PdfStructElem) {
            pointerToNewParent.addNewKid((PdfStructElem)removedKid);
        } else if (removedKid instanceof PdfMcr) {
            PdfMcr mcrKid = this.prepareMcrForMovingToNewParent((PdfMcr)removedKid, pointerToNewParent.getCurrentStructElem());
            pointerToNewParent.addNewKid(mcrKid);
        }
        return this;
    }

    public TagTreePointer relocate(TagTreePointer pointerToNewParent) {
        if (this.getCurrentStructElem().getPdfObject() == this.tagStructureContext.getRootTag().getPdfObject()) {
            throw new PdfException("Cannot relocate root tag.");
        }
        if (this.getCurrentStructElem().isFlushed()) {
            throw new PdfException("Cannot relocate tag which is already flushed.");
        }
        int i = this.getIndexInParentKidsList();
        if (i < 0) {
            throw new PdfException("Cannot relocate tag which parent is already flushed.");
        }
        new TagTreePointer(this).moveToParent().relocateKid(i, pointerToNewParent);
        return this;
    }

    public TagReference getTagReference() {
        return this.getTagReference(-1);
    }

    public TagReference getTagReference(int index) {
        return new TagReference(this.getCurrentElemEnsureIndirect(), this, index);
    }

    public TagTreePointer moveToRoot() {
        this.setCurrentStructElem(this.tagStructureContext.getRootTag());
        return this;
    }

    public TagTreePointer moveToParent() {
        if (this.getCurrentStructElem().getPdfObject() == this.tagStructureContext.getRootTag().getPdfObject()) {
            throw new PdfException("Cannot move to parent current element is root.");
        }
        PdfStructElem parent = (PdfStructElem)this.getCurrentStructElem().getParent();
        if (parent.isFlushed()) {
            Logger logger = LoggerFactory.getLogger(TagTreePointer.class);
            logger.warn("An attempt is made to move the tag tree pointer to the tag parent which has been already flushed. Tag tree pointer is moved to the root tag instead.");
            this.moveToRoot();
        } else {
            this.setCurrentStructElem(parent);
        }
        return this;
    }

    public TagTreePointer moveToKid(int kidIndex) {
        IStructureNode kid = this.getCurrentStructElem().getKids().get(kidIndex);
        if (!(kid instanceof PdfStructElem)) {
            if (kid instanceof PdfMcr) {
                throw new PdfException("Cannot move to marked content reference.");
            }
            throw new PdfException("Cannot move to flushed kid.");
        }
        this.setCurrentStructElem((PdfStructElem)kid);
        return this;
    }

    public TagTreePointer moveToKid(String role) {
        this.moveToKid(0, role);
        return this;
    }

    public TagTreePointer moveToKid(int n, String role) {
        if (MCR_MARKER.equals(role)) {
            throw new PdfException("Cannot move to marked content reference.");
        }
        ArrayList<IStructureNode> descendants = new ArrayList<IStructureNode>(this.getCurrentStructElem().getKids());
        int k = 0;
        for (int i = 0; i < descendants.size(); ++i) {
            if (descendants.get(i) == null || descendants.get(i) instanceof PdfMcr) continue;
            String descendantRole = ((IStructureNode)descendants.get(i)).getRole().getValue();
            if (descendantRole.equals(role) && k++ == n) {
                this.setCurrentStructElem((PdfStructElem)descendants.get(i));
                return this;
            }
            descendants.addAll(((IStructureNode)descendants.get(i)).getKids());
        }
        throw new PdfException("No kid with such role.");
    }

    public List<String> getKidsRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        List<IStructureNode> kids = this.getCurrentStructElem().getKids();
        for (IStructureNode kid : kids) {
            if (kid == null) {
                roles.add(null);
                continue;
            }
            if (kid instanceof PdfStructElem) {
                roles.add(kid.getRole().getValue());
                continue;
            }
            roles.add(MCR_MARKER);
        }
        return roles;
    }

    public TagTreePointer flushTag() {
        if (this.getCurrentStructElem().getPdfObject() == this.tagStructureContext.getRootTag().getPdfObject()) {
            throw new PdfException("Cannot flush document root tag before document is closed.");
        }
        IStructureNode parent = this.tagStructureContext.getWaitingTagsManager().flushTag(this.getCurrentStructElem());
        if (parent != null) {
            this.setCurrentStructElem((PdfStructElem)parent);
        } else {
            this.setCurrentStructElem(this.tagStructureContext.getRootTag());
        }
        return this;
    }

    public TagTreePointer flushParentsIfAllKidsFlushed() {
        this.getContext().flushParentIfBelongsToPage(this.getCurrentStructElem(), null);
        return this;
    }

    public AccessibilityProperties getProperties() {
        return new BackedAccessibilityProperties(this);
    }

    public String getRole() {
        return this.getCurrentStructElem().getRole().getValue();
    }

    public TagTreePointer setRole(String role) {
        this.getCurrentStructElem().setRole(PdfStructTreeRoot.convertRoleToPdfName(role));
        return this;
    }

    public int getIndexInParentKidsList() {
        if (this.getCurrentStructElem().getPdfObject() == this.tagStructureContext.getRootTag().getPdfObject()) {
            return -1;
        }
        PdfStructElem parent = (PdfStructElem)this.getCurrentStructElem().getParent();
        if (parent.isFlushed()) {
            return -1;
        }
        PdfObject k = parent.getK();
        if (k == this.getCurrentStructElem().getPdfObject()) {
            return 0;
        }
        if (k.isArray()) {
            PdfArray kidsArr = (PdfArray)k;
            return kidsArr.indexOf((PdfObject)this.getCurrentStructElem().getPdfObject());
        }
        return -1;
    }

    public TagTreePointer moveToPointer(TagTreePointer tagTreePointer) {
        this.currentStructElem = tagTreePointer.currentStructElem;
        return this;
    }

    public boolean isPointingToSameTag(TagTreePointer otherPointer) {
        return ((PdfDictionary)this.getCurrentStructElem().getPdfObject()).equals(otherPointer.getCurrentStructElem().getPdfObject());
    }

    int createNextMcidForStructElem(PdfStructElem elem, int index) {
        PdfMcr mcr;
        this.throwExceptionIfCurrentPageIsNotInited();
        if (!this.markedContentNotInPageStream() && this.ensureElementPageEqualsKidPage(elem, (PdfDictionary)this.currentPage.getPdfObject())) {
            mcr = new PdfMcrNumber(this.currentPage, elem);
        } else {
            mcr = new PdfMcrDictionary(this.currentPage, elem);
            if (this.markedContentNotInPageStream()) {
                ((PdfDictionary)mcr.getPdfObject()).put(PdfName.Stm, this.contentStream);
            }
        }
        elem.addKid(index, mcr);
        return mcr.getMcid();
    }

    TagTreePointer setCurrentStructElem(PdfStructElem structElem) {
        if (structElem.getParent() == null) {
            throw new PdfException("StructureElement shall contain parent object.");
        }
        this.currentStructElem = structElem;
        return this;
    }

    PdfStructElem getCurrentStructElem() {
        if (this.currentStructElem.isFlushed()) {
            throw new PdfException("TagTreePointer is in invalid state: it points at flushed element. Use TagTreePointer#moveToRoot.");
        }
        PdfIndirectReference indRef = ((PdfDictionary)this.currentStructElem.getPdfObject()).getIndirectReference();
        if (indRef != null && indRef.isFree()) {
            throw new PdfException("TagTreePointer is in invalid state: it points at removed element use TagTreePointer#moveToRoot.");
        }
        return this.currentStructElem;
    }

    private int getNextNewKidPosition() {
        int nextPos = this.nextNewKidIndex;
        this.nextNewKidIndex = -1;
        return nextPos;
    }

    private PdfStructElem addNewKid(String role) {
        PdfStructElem kid = new PdfStructElem(this.getDocument(), PdfStructTreeRoot.convertRoleToPdfName(role));
        this.processKidNamespace(kid);
        return this.addNewKid(kid);
    }

    private PdfStructElem addNewKid(AccessibilityProperties properties) {
        PdfStructElem kid = new PdfStructElem(this.getDocument(), PdfStructTreeRoot.convertRoleToPdfName(properties.getRole()));
        AccessibilityPropertiesToStructElem.apply(properties, kid);
        this.processKidNamespace(kid);
        return this.addNewKid(kid);
    }

    private void processKidNamespace(PdfStructElem kid) {
        PdfNamespace kidNamespace = kid.getNamespace();
        if (this.currentNamespace != null && kidNamespace == null) {
            kid.setNamespace(this.currentNamespace);
            kidNamespace = this.currentNamespace;
        }
        this.tagStructureContext.ensureNamespaceRegistered(kidNamespace);
    }

    private PdfStructElem addNewKid(PdfStructElem kid) {
        return this.getCurrentElemEnsureIndirect().addKid(this.getNextNewKidPosition(), kid);
    }

    private PdfMcr addNewKid(PdfMcr kid) {
        return this.getCurrentElemEnsureIndirect().addKid(this.getNextNewKidPosition(), kid);
    }

    private PdfStructElem getCurrentElemEnsureIndirect() {
        PdfStructElem currentStructElem = this.getCurrentStructElem();
        if (((PdfDictionary)currentStructElem.getPdfObject()).getIndirectReference() == null) {
            currentStructElem.makeIndirect(this.getDocument());
        }
        return currentStructElem;
    }

    private PdfMcr prepareMcrForMovingToNewParent(PdfMcr mcrKid, PdfStructElem newParent) {
        Object mcrObject = mcrKid.getPdfObject();
        PdfDictionary mcrPage = mcrKid.getPageObject();
        PdfDictionary mcrDict = null;
        if (!((PdfObject)mcrObject).isNumber()) {
            mcrDict = (PdfDictionary)mcrObject;
        }
        if (!(mcrDict != null && mcrDict.containsKey(PdfName.Pg) || this.ensureElementPageEqualsKidPage(newParent, mcrPage))) {
            if (mcrDict == null) {
                mcrDict = new PdfDictionary();
                mcrDict.put(PdfName.Type, PdfName.MCR);
                mcrDict.put(PdfName.MCID, (PdfObject)mcrKid.getPdfObject());
            }
            mcrDict.put(PdfName.Pg, mcrPage.getIndirectReference());
        }
        if (mcrDict != null) {
            if (PdfName.MCR.equals(mcrDict.get(PdfName.Type))) {
                mcrKid = new PdfMcrDictionary(mcrDict, newParent);
            } else if (PdfName.OBJR.equals(mcrDict.get(PdfName.Type))) {
                mcrKid = new PdfObjRef(mcrDict, newParent);
            }
        } else {
            mcrKid = new PdfMcrNumber((PdfNumber)mcrObject, newParent);
        }
        return mcrKid;
    }

    private boolean ensureElementPageEqualsKidPage(PdfStructElem elem, PdfDictionary kidPage) {
        PdfObject pageObject = ((PdfDictionary)elem.getPdfObject()).get(PdfName.Pg);
        if (pageObject == null) {
            pageObject = kidPage;
            elem.put(PdfName.Pg, kidPage.getIndirectReference());
        }
        return kidPage.equals(pageObject);
    }

    private boolean markedContentNotInPageStream() {
        return this.contentStream != null;
    }

    private void throwExceptionIfCurrentPageIsNotInited() {
        if (this.currentPage == null) {
            throw new PdfException("Page is not set for the pdf tag structure.");
        }
    }
}

