/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import java.io.IOException;
import java.io.OutputStream;

public class CountOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private long amountOfWrittenBytes = 0L;

    public CountOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.amountOfWrittenBytes += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.amountOfWrittenBytes += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        ++this.amountOfWrittenBytes;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public long getAmountOfWrittenBytes() {
        return this.amountOfWrittenBytes;
    }
}

