/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class StandardNamespaces {
    private static final Set<String> STD_STRUCT_NAMESPACE_1_7_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Document", "Part", "Div", "P", "H", "H1", "H2", "H3", "H4", "H5", "H6", "Lbl", "Span", "Link", "Annot", "Form", "Ruby", "RB", "RT", "RP", "Warichu", "WT", "WP", "L", "LI", "LBody", "Table", "TR", "TH", "TD", "THead", "TBody", "TFoot", "Caption", "Figure", "Formula", "Sect", "Art", "BlockQuote", "TOC", "TOCI", "Index", "NonStruct", "Private", "Quote", "Note", "Reference", "BibEntry", "Code")));
    private static final Set<String> STD_STRUCT_NAMESPACE_2_0_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Document", "DocumentFragment", "Part", "Sect", "NonStruct", "Div", "Aside", "Title", "Sub", "P", "H", "Lbl", "Em", "Strong", "Span", "Link", "Annot", "Form", "Ruby", "RB", "RT", "RP", "Warichu", "WT", "WP", "FENote", "L", "LI", "LBody", "Table", "TR", "TH", "TD", "THead", "TBody", "TFoot", "Caption", "Figure", "Formula", "Artifact")));
    private static final String MATH_ML = "http://www.w3.org/1998/Math/MathML";
    public static final String PDF_1_7 = "http://iso.org/pdf/ssn";
    public static final String PDF_2_0 = "http://iso.org/pdf2/ssn";

    public static String getDefault() {
        return PDF_1_7;
    }

    public static boolean isKnownDomainSpecificNamespace(PdfNamespace namespace) {
        return MATH_ML.equals(namespace.getNamespaceName());
    }

    public static boolean roleBelongsToStandardNamespace(String role, String standardNamespaceName) {
        if (PDF_1_7.equals(standardNamespaceName)) {
            return STD_STRUCT_NAMESPACE_1_7_TYPES.contains(role);
        }
        if (PDF_2_0.equals(standardNamespaceName)) {
            return STD_STRUCT_NAMESPACE_2_0_TYPES.contains(role) || StandardNamespaces.isHnRole(role);
        }
        return false;
    }

    public static boolean isHnRole(String role) {
        if (role.startsWith("H") && role.length() > 1 && role.charAt(1) != '0') {
            try {
                return Integer.parseInt(role.substring(1, role.length())) > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

