/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.DefaultAccessibilityProperties;
import com.itextpdf.layout.element.AbstractElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;

public class Text
extends AbstractElement<Text>
implements ILeafElement,
IAccessibleElement {
    protected String text;
    protected DefaultAccessibilityProperties tagProperties;

    public Text(String text) {
        if (null == text) {
            throw new IllegalArgumentException("Text content cannot be null.");
        }
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getTextRise() {
        return ((Float)this.getProperty(72)).floatValue();
    }

    public Text setTextRise(float textRise) {
        this.setProperty(72, Float.valueOf(textRise));
        return this;
    }

    public Float getHorizontalScaling() {
        return (Float)this.getProperty(29);
    }

    public Text setSkew(float alpha, float beta) {
        alpha = (float)Math.tan((double)alpha * Math.PI / 180.0);
        beta = (float)Math.tan((double)beta * Math.PI / 180.0);
        this.setProperty(65, new float[]{alpha, beta});
        return this;
    }

    public Text setHorizontalScaling(float horizontalScaling) {
        this.setProperty(29, Float.valueOf(horizontalScaling));
        return this;
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new DefaultAccessibilityProperties("Span");
        }
        return this.tagProperties;
    }

    public Text setNeutralRole() {
        this.getAccessibilityProperties().setRole(null);
        return this;
    }

    public Text disableOtfFeatures() {
        this.setProperty(23, (Object)Character.UnicodeScript.UNKNOWN);
        return this;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new TextRenderer(this, this.text);
    }
}

