/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.properties.JustifyContent;
import com.itextpdf.layout.renderer.FlexItemInfo;
import com.itextpdf.layout.renderer.FlexUtil;
import com.itextpdf.layout.renderer.IFlexItemMainDirector;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.List;

class LtrFlexItemMainDirector
implements IFlexItemMainDirector {
    LtrFlexItemMainDirector() {
    }

    @Override
    public List<IRenderer> applyDirection(List<List<FlexItemInfo>> lines) {
        ArrayList<IRenderer> renderers = new ArrayList<IRenderer>();
        for (List<FlexItemInfo> line : lines) {
            this.applyDirectionForLine(line);
            for (FlexItemInfo itemInfo : line) {
                renderers.add(itemInfo.getRenderer());
            }
        }
        return renderers;
    }

    @Override
    public <T> void applyDirectionForLine(List<T> renderers) {
    }

    @Override
    public void applyJustifyContent(List<FlexUtil.FlexItemCalculationInfo> line, JustifyContent justifyContent, float freeSpace) {
        if (freeSpace < 0.0f && (JustifyContent.SPACE_AROUND == justifyContent || JustifyContent.SPACE_BETWEEN == justifyContent || JustifyContent.SPACE_EVENLY == justifyContent)) {
            return;
        }
        switch (justifyContent) {
            case RIGHT: 
            case END: 
            case FLEX_END: {
                line.get((int)0).xShift = freeSpace;
                break;
            }
            case CENTER: {
                line.get((int)0).xShift = freeSpace / 2.0f;
                break;
            }
            case SPACE_BETWEEN: {
                float space = freeSpace / (float)(line.size() - 1);
                for (int i = 1; i < line.size(); ++i) {
                    FlexUtil.FlexItemCalculationInfo item = line.get(i);
                    item.xShift = space;
                }
                break;
            }
            case SPACE_AROUND: {
                float space = freeSpace / (float)(line.size() * 2);
                for (int i = 0; i < line.size(); ++i) {
                    FlexUtil.FlexItemCalculationInfo item = line.get(i);
                    item.xShift = i == 0 ? space : space * 2.0f;
                }
                break;
            }
            case SPACE_EVENLY: {
                float space = freeSpace / (float)(line.size() + 1);
                for (FlexUtil.FlexItemCalculationInfo item : line) {
                    item.xShift = space;
                }
                break;
            }
        }
    }
}

