/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.util.CssVariableUtil;

public class CssDeclarationVarParser
extends CssDeclarationValueTokenizer {
    public CssDeclarationVarParser(String propertyValue) {
        super(propertyValue);
    }

    public VarToken getFirstValidVarToken() {
        CssDeclarationValueTokenizer.Token token;
        int start = -1;
        do {
            if ((token = this.getNextToken()) == null || CssDeclarationValueTokenizer.TokenType.FUNCTION != token.getType() || !CssVariableUtil.containsVarExpression(token.getValue())) continue;
            start = this.index - (token.getValue().length() - token.getValue().indexOf("var")) + 1;
            break;
        } while (token != null);
        if (token == null) {
            return null;
        }
        String tokenValue = token.getValue();
        if (CssDeclarationVarParser.isEndingWithBracket(tokenValue)) {
            String resultTokenValue = this.removeUnclosedBrackets(tokenValue.substring(tokenValue.indexOf("var")));
            return new VarToken(resultTokenValue, start, this.index + 1);
        }
        CssDeclarationValueTokenizer.Token func = this.parseFunctionToken(token, this.functionDepth - 1);
        String resultTokenValue = this.removeUnclosedBrackets(func.getValue().substring(func.getValue().indexOf("var")));
        return new VarToken(resultTokenValue, start, this.index + 1);
    }

    private String removeUnclosedBrackets(String expression) {
        StringBuilder resultBuilder = new StringBuilder();
        int openBrackets = 0;
        int closeBrackets = 0;
        for (int i = 0; i < expression.length(); ++i) {
            if (expression.charAt(i) == '(') {
                ++openBrackets;
            } else if (expression.charAt(i) == ')' && ++closeBrackets > openBrackets) {
                --this.index;
                continue;
            }
            resultBuilder.append(expression.charAt(i));
        }
        String resultTrimmed = resultBuilder.toString().trim();
        this.index -= resultBuilder.length() - resultTrimmed.length();
        return resultTrimmed;
    }

    private static boolean isEndingWithBracket(String expression) {
        for (int i = expression.length() - 1; i >= 0; --i) {
            if (CssDeclarationVarParser.isSpaceOrWhitespace(expression.charAt(i))) continue;
            return ')' == expression.charAt(i);
        }
        return false;
    }

    private static boolean isSpaceOrWhitespace(char character) {
        return Character.isSpaceChar(character) || Character.isWhitespace(character);
    }

    public static class VarToken {
        private final int start;
        private final int end;
        private final String value;

        VarToken(String value, int start, int end) {
            this.value = value;
            this.start = start;
            this.end = end;
        }

        public String getValue() {
            return this.value;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return this.value;
        }
    }
}

