/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate.impl.datatype;

import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.ICssDataTypeValidator;

public class CssLengthValueValidator
implements ICssDataTypeValidator {
    private final boolean allowedNegative;

    public CssLengthValueValidator(boolean allowedNegative) {
        this.allowedNegative = allowedNegative;
    }

    @Override
    public boolean isValid(String objectString) {
        if (objectString == null) {
            return false;
        }
        if ("initial".equals(objectString) || "inherit".equals(objectString) || "unset".equals(objectString)) {
            return true;
        }
        if (!(CssTypesValidationUtils.isMetricValue(objectString) || CssTypesValidationUtils.isRelativeValue(objectString) && !CssTypesValidationUtils.isPercentageValue(objectString) || CssTypesValidationUtils.isZero(objectString))) {
            return false;
        }
        if (CssTypesValidationUtils.isNegativeValue(objectString) && !CssTypesValidationUtils.isZero(objectString)) {
            return this.allowedNegative;
        }
        return true;
    }
}

