/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class WhiteSpaceUtil {
    private static final Set<Character> EM_SPACES;

    public static String collapseConsecutiveSpaces(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (WhiteSpaceUtil.isNonEmSpace(s.charAt(i))) {
                if (sb.length() != 0 && WhiteSpaceUtil.isNonEmSpace(sb.charAt(sb.length() - 1))) continue;
                sb.append(" ");
                continue;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static boolean isNonEmSpace(char ch) {
        return Character.isWhitespace(ch) && !EM_SPACES.contains(Character.valueOf(ch));
    }

    public static boolean isNonLineBreakSpace(char ch) {
        return WhiteSpaceUtil.isNonEmSpace(ch) && ch != '\n';
    }

    public static String processWhitespaces(String text, boolean keepLineBreaks, boolean collapseSpaces) {
        if (!keepLineBreaks && collapseSpaces) {
            text = WhiteSpaceUtil.collapseConsecutiveSpaces(text);
        } else if (keepLineBreaks && collapseSpaces) {
            StringBuilder sb = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                if (WhiteSpaceUtil.isNonLineBreakSpace(text.charAt(i))) {
                    if (sb.length() != 0 && sb.charAt(sb.length() - 1) == ' ') continue;
                    sb.append(" ");
                    continue;
                }
                sb.append(text.charAt(i));
            }
            text = sb.toString();
        } else {
            text = WhiteSpaceUtil.keepLineBreaksAndSpaces(text);
        }
        return text;
    }

    private static String keepLineBreaksAndSpaces(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        sb.append('\u200d');
        for (int i = 0; i < text.length(); ++i) {
            sb.append(text.charAt(i));
            if ('\n' != text.charAt(i) && ('\r' != text.charAt(i) || i + 1 >= text.length() || '\n' == text.charAt(i + 1))) continue;
            sb.append('\u200d');
        }
        if ('\u200d' == sb.charAt(sb.length() - 1)) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    static {
        HashSet<Character> tempSet = new HashSet<Character>();
        tempSet.add(Character.valueOf('\u2002'));
        tempSet.add(Character.valueOf('\u2003'));
        tempSet.add(Character.valueOf('\u2009'));
        EM_SPACES = Collections.unmodifiableSet(tempSet);
    }
}

