/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay.net;

import com.jeequan.jeepay.exception.APIConnectionException;
import com.jeequan.jeepay.exception.JeepayException;
import com.jeequan.jeepay.net.APIResource;
import com.jeequan.jeepay.net.HttpContent;
import com.jeequan.jeepay.net.HttpHeaders;
import com.jeequan.jeepay.net.RequestOptions;
import com.jeequan.jeepay.util.JeepayKit;
import com.jeequan.jeepay.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APIJeepayRequest {
    APIResource.RequestMethod method;
    URL url;
    HttpContent content;
    HttpHeaders headers;
    Map<String, Object> params;
    RequestOptions options;

    public APIJeepayRequest(APIResource.RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws JeepayException {
        try {
            this.params = params != null ? Collections.unmodifiableMap(params) : null;
            this.options = options;
            this.method = method;
            this.url = APIJeepayRequest.buildURL(method, StringUtils.genUrl(url, this.options.getUri()), params);
            this.content = APIJeepayRequest.buildContent(method, params, this.options);
            this.headers = APIJeepayRequest.buildHeaders(method, this.options);
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("\u8bf7\u6c42Jeepay(%s)\u5f02\u5e38,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u91cd\u8bd5.\u5f02\u5e38\u4fe1\u606f:%s", StringUtils.genUrl(url, options.getUri()), e.getMessage()), e);
        }
    }

    private static URL buildURL(APIResource.RequestMethod method, String spec, Map<String, Object> params) throws IOException {
        String queryString;
        StringBuilder sb = new StringBuilder();
        sb.append(spec);
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT && params != null && !(queryString = APIJeepayRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        return new URL(sb.toString());
    }

    public static URL buildURLWithSign(String url, Map<String, Object> params, RequestOptions options) throws APIConnectionException {
        String queryString;
        String signature;
        params.put("version", options.getVersion());
        params.put("signType", options.getSignType());
        String requestTime = APIJeepayRequest.currentTimeString();
        params.put("reqTime", requestTime);
        try {
            signature = APIJeepayRequest.buildJeepaySignature(params, options);
        }
        catch (IOException e) {
            throw new APIConnectionException("\u751f\u6210Jeepay\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", e);
        }
        if (signature != null) {
            params.put("sign", signature);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.genUrl(url, options.getUri()));
        if (params != null && !(queryString = APIJeepayRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        try {
            return new URL(sb.toString());
        }
        catch (IOException e) {
            throw new APIConnectionException("\u751f\u6210 Jeepay \u8bf7\u6c42URL\u5f02\u5e38", e);
        }
    }

    private static HttpContent buildContent(APIResource.RequestMethod method, Map<String, Object> params, RequestOptions options) throws JeepayException {
        String signature;
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT) {
            return null;
        }
        if (params == null) {
            return null;
        }
        params.put("version", options.getVersion());
        params.put("signType", options.getSignType());
        String requestTime = APIJeepayRequest.currentTimeString();
        params.put("reqTime", requestTime);
        try {
            signature = APIJeepayRequest.buildJeepaySignature(params, options);
        }
        catch (IOException e) {
            throw new APIConnectionException("\u751f\u6210Jeepay\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", e);
        }
        if (signature != null) {
            params.put("sign", signature);
        }
        return HttpContent.buildJSONContent(params);
    }

    private static String createQuery(Map<String, Object> params) {
        if (params == null) {
            return "";
        }
        Map<String, String> flatParams = APIJeepayRequest.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIJeepayRequest.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static String urlEncodePair(String k, String v) {
        return String.format("%s=%s", APIJeepayRequest.urlEncode(k), APIJeepayRequest.urlEncode(v));
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIJeepayRequest.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList ar = (ArrayList)value;
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    flatNestedMap.put(String.format("%s[%d]", key, i), ar.get(i));
                }
                flatParams.putAll(APIJeepayRequest.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static HttpHeaders buildHeaders(APIResource.RequestMethod method, RequestOptions options) throws JeepayException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Collections.singletonList("application/json"));
        headerMap.put("Accept-Charset", Collections.singletonList(APIResource.CHARSET.name()));
        headerMap.put("Accept-Language", Collections.singletonList(options.getAcceptLanguage()));
        return HttpHeaders.of(headerMap);
    }

    protected static String buildJeepaySignature(Map<String, Object> params, RequestOptions options) throws IOException {
        String signType = options.getSignType();
        if ("MD5".equalsIgnoreCase(signType)) {
            return JeepayKit.getSign(params, options.getApiKey());
        }
        if ("RSA2".equalsIgnoreCase(signType)) {
            throw new AssertionError((Object)"\u6682\u4e0d\u652f\u6301RSA2\u7b7e\u540d");
        }
        throw new AssertionError((Object)"\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u7c7b\u578b");
    }

    protected static String currentTimeString() {
        int requestTime = (int)(System.currentTimeMillis() / 1000L);
        return Integer.toString(requestTime);
    }

    public APIResource.RequestMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public RequestOptions getOptions() {
        return this.options;
    }
}

