/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import com.jfinal.server.undertow.PropExt;
import com.jfinal.server.undertow.ResourceManagerBuilder;
import com.jfinal.server.undertow.UndertowKit;
import com.jfinal.server.undertow.hotswap.ClassLoaderKit;
import com.jfinal.server.undertow.hotswap.HotSwapResolver;
import com.jfinal.server.undertow.ssl.SslConfig;
import io.undertow.Undertow;
import io.undertow.server.handlers.resource.ResourceManager;

public class UndertowConfig {
    static final String UNDERTOW_CONFIG = "undertow.txt";
    static final String DEV_MODE = "undertow.devMode";
    static final String PORT = "undertow.port";
    static final String HOST = "undertow.host";
    static final String CONTEXT_PATH = "undertow.contextPath";
    static final String RESOURCE_PATH = "undertow.resourcePath";
    static final String IO_THREADS = "undertow.ioThreads";
    static final String WORKER_THREADS = "undertow.workerThreads";
    static final String GZIP_ENABLE = "undertow.gzip.enable";
    static final String GZIP_LEVEL = "undertow.gzip.level";
    static final String GZIP_MIN_LENGTH = "undertow.gzip.minLength";
    static final String HTTP2_ENABLE = "undertow.http2.enable";
    static final String SESSION_TIMEOUT = "undertow.session.timeout";
    static final String SESSION_HOT_SWAP = "undertow.session.hotSwap";
    static final String HOT_SWAP_CLASS_PREFIX = "undertow.hotSwapClassPrefix";
    static final String HTTP_TO_HTTPS = "undertow.http.toHttps";
    static final String HTTP_TO_HTTPS_STATUS_CODE = "undertow.http.toHttpsStatusCode";
    static final String HTTP_DISABLE = "undertow.http.disable";
    static final String SERVER_NAME = "undertow.serverName";
    protected String jfinalConfig;
    protected static volatile boolean devMode = false;
    protected int port = 80;
    protected String host = "0.0.0.0";
    protected String contextPath = "/";
    protected String resourcePath = "src/main/webapp, WebRoot, WebContent";
    protected Integer ioThreads = null;
    protected Integer workerThreads = null;
    protected boolean gzipEnable = false;
    protected int gzipLevel = -1;
    protected int gzipMinLength = 1024;
    protected Boolean http2Enable = null;
    protected Integer sessionTimeout = null;
    protected boolean sessionHotSwap = true;
    protected String hotSwapClassPrefix = null;
    protected SslConfig sslConfig = null;
    protected boolean httpToHttps = false;
    protected int httpToHttpsStatusCode = 302;
    protected boolean httpDisable = false;
    protected String serverName = null;
    protected String[] classPathDirs;
    protected HotSwapResolver hotSwapResolver;
    protected ClassLoaderKit classLoaderKit;
    protected PropExt p;

    public UndertowConfig(Class<?> jfinalConfigClass) {
        this(jfinalConfigClass.getName());
    }

    public UndertowConfig(String jfinalConfigClass) {
        this.jfinalConfig = jfinalConfigClass;
        this.p = this.createPropExt(UNDERTOW_CONFIG);
        if (this.p.notEmpty()) {
            this.init();
        }
    }

    public UndertowConfig(Class<?> jfinalConfigClass, String undertowConfig) {
        this(jfinalConfigClass.getName(), undertowConfig);
    }

    public UndertowConfig(String jfinalConfigClass, String undertowConfig) {
        this.jfinalConfig = jfinalConfigClass;
        undertowConfig = undertowConfig.trim();
        this.p = this.createPropExt(undertowConfig);
        if (this.p.notEmpty()) {
            this.init();
        }
    }

    protected PropExt createPropExt(String undertowConfig) {
        PropExt ret = UNDERTOW_CONFIG.equals(undertowConfig) ? new PropExt().appendIfExists(undertowConfig) : new PropExt().append(undertowConfig);
        return ret.appendIfExists(this.buildUndertowConfigPro(undertowConfig));
    }

    protected String buildUndertowConfigPro(String undertowConfig) {
        int index = undertowConfig.lastIndexOf(46);
        if (index > 0) {
            String main = undertowConfig.substring(0, index);
            main = this.removeDevEnds(main);
            String ext = undertowConfig.substring(index);
            return main + "-pro" + ext;
        }
        return this.removeDevEnds(undertowConfig) + "-pro";
    }

    private String removeDevEnds(String main) {
        if (main.length() > 4) {
            if (main.endsWith("-dev")) {
                main = main.substring(0, main.lastIndexOf("-dev"));
            } else if (main.endsWith("_dev")) {
                main = main.substring(0, main.lastIndexOf("_dev"));
            }
        }
        return main;
    }

    protected void init() {
        devMode = this.p.getBoolean(DEV_MODE, devMode);
        this.port = this.p.getInt(PORT, this.port);
        this.host = this.p.get(HOST, this.host).trim();
        this.contextPath = this.p.get(CONTEXT_PATH, this.contextPath).trim();
        this.resourcePath = this.p.get(RESOURCE_PATH, this.resourcePath).trim();
        this.ioThreads = this.buildIoThreads();
        this.workerThreads = this.buildWorkerThreads();
        this.gzipEnable = this.p.getBoolean(GZIP_ENABLE, this.gzipEnable);
        this.gzipLevel = this.checkGzipLevel(this.p.getInt(GZIP_LEVEL, this.gzipLevel));
        this.gzipMinLength = this.p.getInt(GZIP_MIN_LENGTH, this.gzipMinLength);
        this.http2Enable = this.p.getBoolean(HTTP2_ENABLE, this.http2Enable);
        this.sessionTimeout = this.p.getInt(SESSION_TIMEOUT, this.sessionTimeout);
        this.sessionHotSwap = this.p.getBoolean(SESSION_HOT_SWAP, this.sessionHotSwap);
        this.hotSwapClassPrefix = this.p.get(HOT_SWAP_CLASS_PREFIX, this.hotSwapClassPrefix);
        this.sslConfig = new SslConfig(this.p);
        this.httpToHttps = this.p.getBoolean(HTTP_TO_HTTPS, this.httpToHttps);
        this.httpToHttpsStatusCode = this.p.getInt(HTTP_TO_HTTPS_STATUS_CODE, this.httpToHttpsStatusCode);
        this.httpDisable = this.p.getBoolean(HTTP_DISABLE, this.httpDisable);
        this.serverName = this.p.get(SERVER_NAME);
    }

    protected Integer buildIoThreads() {
        Integer valueFromConfig = this.p.getInt(IO_THREADS);
        if (valueFromConfig != null) {
            return valueFromConfig;
        }
        int cpuNum = Runtime.getRuntime().availableProcessors();
        if (UndertowConfig.isDevMode() && UndertowKit.notDeployMode()) {
            return 2;
        }
        return new Long(Math.round((double)cpuNum * 1.6180339)).intValue();
    }

    protected Integer buildWorkerThreads() {
        Integer valueFromConfig = this.p.getInt(WORKER_THREADS);
        if (valueFromConfig != null) {
            return valueFromConfig;
        }
        if (UndertowConfig.isDevMode() && UndertowKit.notDeployMode()) {
            return 4;
        }
        return this.ioThreads * 16;
    }

    protected int checkGzipLevel(int gzipLevel) {
        if (gzipLevel != -1 && (gzipLevel < 1 || gzipLevel > 9)) {
            throw new IllegalArgumentException("undertow.gzip.level \u4e0d\u80fd\u914d\u7f6e\u4e3a " + gzipLevel + ", \u53ef\u914d\u7f6e\u7684\u503c\u4e3a: -1, 1, 2, 3, 4, 5, 6, 7, 8, 9");
        }
        return gzipLevel;
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean notBlank(String str) {
        return !UndertowConfig.isBlank(str);
    }

    public String getJFinalConfig() {
        return this.jfinalConfig;
    }

    public ResourceManager getResourceManager() {
        return new ResourceManagerBuilder().build(this.resourcePath, this.getClassLoader());
    }

    protected ClassLoaderKit getClassLoaderKit() {
        if (this.classLoaderKit == null) {
            this.classLoaderKit = new ClassLoaderKit(Undertow.class.getClassLoader(), this.getHotSwapResolver());
        }
        return this.classLoaderKit;
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoaderKit().getClassLoader();
    }

    public void replaceClassLoader() {
        if (UndertowConfig.isDevMode()) {
            this.getClassLoaderKit().replaceClassLoader();
        }
    }

    public HotSwapResolver getHotSwapResolver() {
        if (this.hotSwapResolver == null) {
            this.hotSwapResolver = new HotSwapResolver(this.getClassPathDirs());
            if (this.hotSwapClassPrefix != null) {
                for (String prefix : this.hotSwapClassPrefix.split(",")) {
                    if (!UndertowConfig.notBlank(prefix)) continue;
                    this.hotSwapResolver.addHotSwapClassPrefix(prefix);
                }
            }
        }
        return this.hotSwapResolver;
    }

    public void setHotSwapResolver(HotSwapResolver hotSwapResolver) {
        this.hotSwapResolver = hotSwapResolver;
    }

    public void addSystemClassPrefix(String prefix) {
        this.getHotSwapResolver().addSystemClassPrefix(prefix);
    }

    public void addHotSwapClassPrefix(String prefix) {
        this.getHotSwapResolver().addHotSwapClassPrefix(prefix);
    }

    public String[] getClassPathDirs() {
        if (this.classPathDirs == null) {
            this.classPathDirs = UndertowKit.getClassPathDirs();
        }
        return this.classPathDirs;
    }

    public void setDevMode(boolean devMode) {
        if (this.p.getBoolean(DEV_MODE) == null) {
            UndertowConfig.devMode = devMode;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.devMode = " + this.p.getBoolean(DEV_MODE));
        }
    }

    public static boolean isDevMode() {
        return devMode;
    }

    public void setPort(int port) {
        if (this.p.getInt(PORT) == null) {
            this.port = port;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.port = " + this.p.getInt(PORT));
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setContextPath(String contextPath) {
        if (this.p.get(CONTEXT_PATH) == null) {
            this.contextPath = contextPath;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.contextPath = " + this.p.get(CONTEXT_PATH));
        }
    }

    public String getContextPath() {
        if ("/".equals(this.contextPath)) {
            return this.contextPath;
        }
        if (UndertowConfig.isBlank(this.contextPath)) {
            this.contextPath = "/";
            return this.contextPath;
        }
        if (!this.contextPath.startsWith("/")) {
            this.contextPath = "/" + this.contextPath;
        }
        if (this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath.substring(0, this.contextPath.length() - 1);
        }
        return this.contextPath;
    }

    public void setResourcePath(String resourcePath) {
        if (UndertowConfig.isBlank(resourcePath)) {
            throw new IllegalArgumentException("resourcePath can not be blank");
        }
        if (this.p.get(RESOURCE_PATH) == null) {
            this.resourcePath = resourcePath;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.resourcePath = " + this.p.get(RESOURCE_PATH));
        }
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setHost(String host) {
        if (this.p.get(HOST) == null) {
            this.host = host;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.host = " + this.p.get(HOST));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setIoThreads(int ioThreads) {
        if (this.p.getInt(IO_THREADS) == null) {
            this.ioThreads = ioThreads;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.ioThreads = " + this.p.getInt(IO_THREADS));
        }
    }

    public Integer getIoThreads() {
        return this.ioThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        if (this.p.getInt(WORKER_THREADS) == null) {
            this.workerThreads = workerThreads;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.workerThreads = " + this.p.getInt(WORKER_THREADS));
        }
    }

    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    public void setGzipEnable(boolean gzipEnable) {
        if (this.p.getBoolean(GZIP_ENABLE) == null) {
            this.gzipEnable = gzipEnable;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.gzip.enable = " + this.p.getBoolean(GZIP_ENABLE));
        }
    }

    public boolean isGzipEnable() {
        return this.gzipEnable;
    }

    public void setGzipLevel(int gzipLevel) {
        if (this.p.getInt(GZIP_LEVEL) == null) {
            this.gzipLevel = this.checkGzipLevel(gzipLevel);
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.gzip.level = " + this.p.getInt(GZIP_LEVEL));
        }
    }

    public int getGzipLevel() {
        return this.gzipLevel;
    }

    public void setGzipMinLength(int gzipMinLength) {
        if (this.p.getInt(GZIP_MIN_LENGTH) == null) {
            this.gzipMinLength = gzipMinLength;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.gzip.minLength = " + this.p.getInt(GZIP_MIN_LENGTH));
        }
    }

    public int getGzipMinLength() {
        return this.gzipMinLength;
    }

    public void setHttp2Enable(boolean http2Enable) {
        if (this.p.getBoolean(HTTP2_ENABLE) == null) {
            this.http2Enable = http2Enable;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.http2.enable = " + this.p.getBoolean(HTTP2_ENABLE));
        }
    }

    public Boolean getHttp2Enable() {
        return this.http2Enable;
    }

    public void setSessionTimeout(int sessionTimeout) {
        if (this.p.getInt(SESSION_TIMEOUT) == null) {
            this.sessionTimeout = sessionTimeout;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.session.timeout = " + this.p.getInt(SESSION_TIMEOUT));
        }
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionHotSwap(boolean sessionHotSwap) {
        if (this.p.getBoolean(SESSION_HOT_SWAP) == null) {
            this.sessionHotSwap = sessionHotSwap;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.session.hotSwap = " + this.p.getBoolean(SESSION_HOT_SWAP));
        }
    }

    public boolean getSessionHotSwap() {
        return this.sessionHotSwap;
    }

    public boolean isSslEnable() {
        return this.sslConfig != null && this.sslConfig.isEnable();
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void setHttpToHttps(boolean httpToHttps) {
        if (this.p.getBoolean(HTTP_TO_HTTPS) == null) {
            this.httpToHttps = httpToHttps;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.http.toHttps = " + this.p.getBoolean(HTTP_TO_HTTPS));
        }
    }

    public boolean isHttpToHttps() {
        return this.httpToHttps;
    }

    public void setHttpToHttpsStatusCode(int httpToHttpsStatusCode) {
        if (this.p.getInt(HTTP_TO_HTTPS_STATUS_CODE) == null) {
            this.httpToHttpsStatusCode = httpToHttpsStatusCode;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.http.toHttpsStatusCode = " + this.p.getInt(HTTP_TO_HTTPS_STATUS_CODE));
        }
    }

    public int getHttpToHttpsStatusCode() {
        return this.httpToHttpsStatusCode;
    }

    public void setHttpDisable(boolean httpDisable) {
        if (this.p.getBoolean(HTTP_DISABLE) == null) {
            this.httpDisable = httpDisable;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.http.disable = " + this.p.getBoolean(HTTP_DISABLE));
        }
    }

    public boolean isHttpDisable() {
        return this.httpDisable;
    }

    public void setServerName(String serverName) {
        if (this.p.get(SERVER_NAME) == null) {
            this.serverName = serverName;
        } else {
            System.out.println("undertow-server: \u4f18\u5148\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 undertow.serverName = " + this.p.get(SERVER_NAME));
        }
    }

    public String getServerName() {
        if (UndertowConfig.isBlank(this.serverName)) {
            return "JFinal " + UndertowKit.getJFinalVersion();
        }
        return "disable".equals(this.serverName.trim()) ? null : this.serverName.trim();
    }
}

