/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.ehr.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.ehr.v1.model.GetAttachmentReq;
import com.lark.oapi.service.ehr.v1.model.GetAttachmentResp;
import com.lark.oapi.service.ehr.v1.model.ListEmployeeReq;
import com.lark.oapi.service.ehr.v1.model.ListEmployeeResp;
import java.io.ByteArrayOutputStream;

public class EhrService {
    private final Attachment attachment;
    private final Employee employee;

    public EhrService(Config config) {
        this.attachment = new Attachment(config);
        this.employee = new Employee(config);
    }

    public Attachment attachment() {
        return this.attachment;
    }

    public Employee employee() {
        return this.employee;
    }

    public static class Employee {
        private final Config config;

        public Employee(Config config) {
            this.config = config;
        }

        public ListEmployeeResp list(ListEmployeeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/ehr/v1/employees", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListEmployeeResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public ListEmployeeResp list(ListEmployeeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/ehr/v1/employees", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListEmployeeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListEmployeeResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }

    public static class Attachment {
        private final Config config;

        public Attachment(Config config) {
            this.config = config;
        }

        public GetAttachmentResp get(GetAttachmentReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/ehr/v1/attachments/:token", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                GetAttachmentResp resp = new GetAttachmentResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setFileStream(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            GetAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAttachmentResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }

        public GetAttachmentResp get(GetAttachmentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            reqOptions.setSupportDownLoad(true);
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/ehr/v1/attachments/:token", Sets.newHashSet(AccessTokenType.Tenant), req);
            if (httpResponse.getStatusCode() == 200) {
                GetAttachmentResp resp = new GetAttachmentResp();
                resp.setRawResponse(httpResponse);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(httpResponse.getBody());
                resp.setFileStream(outputStream);
                resp.setFileName(httpResponse.getFileName());
                return resp;
            }
            GetAttachmentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetAttachmentResp.class);
            resp.setRawResponse(httpResponse);
            return resp;
        }
    }
}

