/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hook;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookCan {
    private static final Logger log = LoggerFactory.getLogger(HookCan.class);
    private static HookCan me = new HookCan();
    private List<Runnable> destroyMethods = new ArrayList<Runnable>();

    public static HookCan me() {
        return me;
    }

    private HookCan() {
    }

    public void addDestroyMethod(Runnable task) {
        this.destroyMethods.add(task);
    }

    public List<Runnable> getDestroyMethods() {
        return this.destroyMethods;
    }

    public void clear() {
        this.destroyMethods.clear();
    }

    public void stop() {
        Iterator<Runnable> iterator = this.destroyMethods.iterator();
        while (iterator.hasNext()) {
            Runnable runnable = iterator.next();
            iterator.remove();
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error("error occured while :{}", (Object)runnable);
            }
        }
        me = new HookCan();
    }

    public void setDestroyMethods(List<Runnable> destroyMethods) {
        this.destroyMethods = destroyMethods;
    }
}

