/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.model.sys;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;

public class SystemInfo
implements Serializable {
    private static final long serialVersionUID = -4158984832920624527L;
    private int availableProcessors;
    private double systemLoadAverage;
    private long cpuUsage;
    private long totalPhysicalMemorySize;
    private long freePhysicalMemorySize;
    private long usedMemory;
    private long heapMemoryUsed;
    private long heapMemoryMax;
    private long nonHeapMemoryUsed;
    private long nonHeapMemoryMax;
    private String javaVersion;
    private String jvmVendor;
    private long jvmUptime;
    private String osName;
    private String osVersion;
    private String osArch;
    private File[] fileRoots;

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    public long getCpuUsage() {
        return this.cpuUsage;
    }

    public long getTotalPhysicalMemorySize() {
        return this.totalPhysicalMemorySize;
    }

    public long getFreePhysicalMemorySize() {
        return this.freePhysicalMemorySize;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getHeapMemoryUsed() {
        return this.heapMemoryUsed;
    }

    public long getHeapMemoryMax() {
        return this.heapMemoryMax;
    }

    public long getNonHeapMemoryUsed() {
        return this.nonHeapMemoryUsed;
    }

    public long getNonHeapMemoryMax() {
        return this.nonHeapMemoryMax;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJvmVendor() {
        return this.jvmVendor;
    }

    public long getJvmUptime() {
        return this.jvmUptime;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public File[] getFileRoots() {
        return this.fileRoots;
    }

    public void setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    public void setSystemLoadAverage(double systemLoadAverage) {
        this.systemLoadAverage = systemLoadAverage;
    }

    public void setCpuUsage(long cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public void setTotalPhysicalMemorySize(long totalPhysicalMemorySize) {
        this.totalPhysicalMemorySize = totalPhysicalMemorySize;
    }

    public void setFreePhysicalMemorySize(long freePhysicalMemorySize) {
        this.freePhysicalMemorySize = freePhysicalMemorySize;
    }

    public void setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
    }

    public void setHeapMemoryUsed(long heapMemoryUsed) {
        this.heapMemoryUsed = heapMemoryUsed;
    }

    public void setHeapMemoryMax(long heapMemoryMax) {
        this.heapMemoryMax = heapMemoryMax;
    }

    public void setNonHeapMemoryUsed(long nonHeapMemoryUsed) {
        this.nonHeapMemoryUsed = nonHeapMemoryUsed;
    }

    public void setNonHeapMemoryMax(long nonHeapMemoryMax) {
        this.nonHeapMemoryMax = nonHeapMemoryMax;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setJvmVendor(String jvmVendor) {
        this.jvmVendor = jvmVendor;
    }

    public void setJvmUptime(long jvmUptime) {
        this.jvmUptime = jvmUptime;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    public void setFileRoots(File[] fileRoots) {
        this.fileRoots = fileRoots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemInfo)) {
            return false;
        }
        SystemInfo other = (SystemInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAvailableProcessors() != other.getAvailableProcessors()) {
            return false;
        }
        if (Double.compare(this.getSystemLoadAverage(), other.getSystemLoadAverage()) != 0) {
            return false;
        }
        if (this.getCpuUsage() != other.getCpuUsage()) {
            return false;
        }
        if (this.getTotalPhysicalMemorySize() != other.getTotalPhysicalMemorySize()) {
            return false;
        }
        if (this.getFreePhysicalMemorySize() != other.getFreePhysicalMemorySize()) {
            return false;
        }
        if (this.getUsedMemory() != other.getUsedMemory()) {
            return false;
        }
        if (this.getHeapMemoryUsed() != other.getHeapMemoryUsed()) {
            return false;
        }
        if (this.getHeapMemoryMax() != other.getHeapMemoryMax()) {
            return false;
        }
        if (this.getNonHeapMemoryUsed() != other.getNonHeapMemoryUsed()) {
            return false;
        }
        if (this.getNonHeapMemoryMax() != other.getNonHeapMemoryMax()) {
            return false;
        }
        if (this.getJvmUptime() != other.getJvmUptime()) {
            return false;
        }
        String this$javaVersion = this.getJavaVersion();
        String other$javaVersion = other.getJavaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
            return false;
        }
        String this$jvmVendor = this.getJvmVendor();
        String other$jvmVendor = other.getJvmVendor();
        if (this$jvmVendor == null ? other$jvmVendor != null : !this$jvmVendor.equals(other$jvmVendor)) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        String this$osVersion = this.getOsVersion();
        String other$osVersion = other.getOsVersion();
        if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
            return false;
        }
        String this$osArch = this.getOsArch();
        String other$osArch = other.getOsArch();
        if (this$osArch == null ? other$osArch != null : !this$osArch.equals(other$osArch)) {
            return false;
        }
        return Arrays.deepEquals(this.getFileRoots(), other.getFileRoots());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAvailableProcessors();
        long $systemLoadAverage = Double.doubleToLongBits(this.getSystemLoadAverage());
        result = result * 59 + (int)($systemLoadAverage >>> 32 ^ $systemLoadAverage);
        long $cpuUsage = this.getCpuUsage();
        result = result * 59 + (int)($cpuUsage >>> 32 ^ $cpuUsage);
        long $totalPhysicalMemorySize = this.getTotalPhysicalMemorySize();
        result = result * 59 + (int)($totalPhysicalMemorySize >>> 32 ^ $totalPhysicalMemorySize);
        long $freePhysicalMemorySize = this.getFreePhysicalMemorySize();
        result = result * 59 + (int)($freePhysicalMemorySize >>> 32 ^ $freePhysicalMemorySize);
        long $usedMemory = this.getUsedMemory();
        result = result * 59 + (int)($usedMemory >>> 32 ^ $usedMemory);
        long $heapMemoryUsed = this.getHeapMemoryUsed();
        result = result * 59 + (int)($heapMemoryUsed >>> 32 ^ $heapMemoryUsed);
        long $heapMemoryMax = this.getHeapMemoryMax();
        result = result * 59 + (int)($heapMemoryMax >>> 32 ^ $heapMemoryMax);
        long $nonHeapMemoryUsed = this.getNonHeapMemoryUsed();
        result = result * 59 + (int)($nonHeapMemoryUsed >>> 32 ^ $nonHeapMemoryUsed);
        long $nonHeapMemoryMax = this.getNonHeapMemoryMax();
        result = result * 59 + (int)($nonHeapMemoryMax >>> 32 ^ $nonHeapMemoryMax);
        long $jvmUptime = this.getJvmUptime();
        result = result * 59 + (int)($jvmUptime >>> 32 ^ $jvmUptime);
        String $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
        String $jvmVendor = this.getJvmVendor();
        result = result * 59 + ($jvmVendor == null ? 43 : $jvmVendor.hashCode());
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        String $osVersion = this.getOsVersion();
        result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
        String $osArch = this.getOsArch();
        result = result * 59 + ($osArch == null ? 43 : $osArch.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFileRoots());
        return result;
    }

    public String toString() {
        return "SystemInfo(availableProcessors=" + this.getAvailableProcessors() + ", systemLoadAverage=" + this.getSystemLoadAverage() + ", cpuUsage=" + this.getCpuUsage() + ", totalPhysicalMemorySize=" + this.getTotalPhysicalMemorySize() + ", freePhysicalMemorySize=" + this.getFreePhysicalMemorySize() + ", usedMemory=" + this.getUsedMemory() + ", heapMemoryUsed=" + this.getHeapMemoryUsed() + ", heapMemoryMax=" + this.getHeapMemoryMax() + ", nonHeapMemoryUsed=" + this.getNonHeapMemoryUsed() + ", nonHeapMemoryMax=" + this.getNonHeapMemoryMax() + ", javaVersion=" + this.getJavaVersion() + ", jvmVendor=" + this.getJvmVendor() + ", jvmUptime=" + this.getJvmUptime() + ", osName=" + this.getOsName() + ", osVersion=" + this.getOsVersion() + ", osArch=" + this.getOsArch() + ", fileRoots=" + Arrays.deepToString(this.getFileRoots()) + ")";
    }

    public SystemInfo() {
    }

    public SystemInfo(int availableProcessors, double systemLoadAverage, long cpuUsage, long totalPhysicalMemorySize, long freePhysicalMemorySize, long usedMemory, long heapMemoryUsed, long heapMemoryMax, long nonHeapMemoryUsed, long nonHeapMemoryMax, String javaVersion, String jvmVendor, long jvmUptime, String osName, String osVersion, String osArch, File[] fileRoots) {
        this.availableProcessors = availableProcessors;
        this.systemLoadAverage = systemLoadAverage;
        this.cpuUsage = cpuUsage;
        this.totalPhysicalMemorySize = totalPhysicalMemorySize;
        this.freePhysicalMemorySize = freePhysicalMemorySize;
        this.usedMemory = usedMemory;
        this.heapMemoryUsed = heapMemoryUsed;
        this.heapMemoryMax = heapMemoryMax;
        this.nonHeapMemoryUsed = nonHeapMemoryUsed;
        this.nonHeapMemoryMax = nonHeapMemoryMax;
        this.javaVersion = javaVersion;
        this.jvmVendor = jvmVendor;
        this.jvmUptime = jvmUptime;
        this.osName = osName;
        this.osVersion = osVersion;
        this.osArch = osArch;
        this.fileRoots = fileRoots;
    }
}

