/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.utils;

import com.lmaye.app.common.context.IResultCode;
import com.lmaye.app.common.context.ResultCode;
import com.lmaye.app.common.exception.CoreException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.springframework.core.io.ClassPathResource;

public final class IpUtils {
    private static final String DEFAULT_FILL = "0";
    private static final DbSearcher SEARCHER;

    public static String getRegion(String ip) {
        try {
            DataBlock block = SEARCHER.memorySearch(ip);
            return block.getRegion();
        }
        catch (IOException e) {
            throw new CoreException((IResultCode)ResultCode.GET_IP_ADDRESS_FAILED, (Throwable)e);
        }
    }

    public static String[] getRegions(String ip) {
        String region = IpUtils.getRegion(ip);
        if (!StringUtils.isEmpty((CharSequence)region)) {
            int i;
            String[] regions = region.split("\\|");
            int length = regions.length;
            for (i = 0; i < length; ++i) {
                if (i < 1 || !StringUtils.isEmpty((CharSequence)regions[i]) && !Objects.equals(DEFAULT_FILL, regions[i])) continue;
                regions[i] = regions[i - 1];
            }
            for (i = length - 1; i >= 0; --i) {
                if (i >= length - 1 || !StringUtils.isEmpty((CharSequence)regions[i]) && !Objects.equals(DEFAULT_FILL, regions[i])) continue;
                regions[i] = regions[i + 1];
            }
            return regions;
        }
        throw new CoreException((IResultCode)ResultCode.GET_IP_ADDRESS_FAILED);
    }

    private IpUtils() {
    }

    static {
        ClassPathResource resource = new ClassPathResource("ip2region.db");
        try (InputStream is = resource.getInputStream();){
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            DbConfig config = new DbConfig();
            SEARCHER = new DbSearcher(config, bytes);
        }
        catch (Exception e) {
            throw new CoreException((IResultCode)ResultCode.IP_DATA_INIT_FAILED, (Throwable)e);
        }
    }
}

