/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.lmaye.app.common.constants.CoreConstants;
import com.lmaye.app.common.context.IResultCode;
import com.lmaye.app.common.context.ResultCode;
import com.lmaye.app.common.exception.CoreException;
import java.io.IOException;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> String toStr(T bean) {
        try {
            return OBJECT_MAPPER.writeValueAsString(bean);
        }
        catch (Exception e) {
            throw new CoreException((IResultCode)ResultCode.JSON_BEAN_TO_STR_FAILED, (Throwable)e);
        }
    }

    public static <T> T toBean(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new CoreException((IResultCode)ResultCode.JSON_STR_TO_BEAN_FAILED, (Throwable)e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    private JsonUtils() {
    }

    static {
        OBJECT_MAPPER.setLocale(Locale.CHINA);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        OBJECT_MAPPER.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.setDateFormat((DateFormat)CoreConstants.SIMPLE_DATE_FORMAT);
        OBJECT_MAPPER.setTimeZone(CoreConstants.TIME_ZONE);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(CoreConstants.YYYY_MM_DD_HH_MM_SS));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(CoreConstants.YYYY_MM_DD));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(CoreConstants.HH_MM_SS));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(CoreConstants.YYYY_MM_DD_HH_MM_SS));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(CoreConstants.YYYY_MM_DD));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(CoreConstants.HH_MM_SS));
        OBJECT_MAPPER.registerModule((Module)javaTimeModule);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        OBJECT_MAPPER.registerModule((Module)simpleModule);
    }
}

