/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.validator;

import com.lmaye.starter.data.web.validator.constraints.Ip;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.logging.log4j.util.Strings;

public class IpValidator
implements ConstraintValidator<Ip, String> {
    private static final Pattern IP_PATTERN = Pattern.compile("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");

    public static boolean isIp(String ip) {
        return IP_PATTERN.matcher(ip).matches();
    }

    public void initialize(Ip constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return Strings.isBlank((String)value) || IpValidator.isIp(value);
    }
}

