/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.validator;

import com.lmaye.starter.data.web.validator.constraints.Password;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.logging.log4j.util.Strings;

public class PasswordValidator
implements ConstraintValidator<Password, String> {
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(?![0-9]+$)(?![a-zA-Z]+$)(?!(![0-9A-Za-z])+$)\\S{6,32}");

    public static boolean isPassword(String password) {
        return PASSWORD_PATTERN.matcher(password).matches();
    }

    public void initialize(Password constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return Strings.isBlank((String)value) || PasswordValidator.isPassword(value);
    }
}

