/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.validator;

import com.lmaye.app.common.context.IResultCode;
import com.lmaye.app.common.context.ResultCode;
import com.lmaye.app.common.exception.CoreException;
import com.lmaye.starter.data.web.validator.constraints.Safe;
import java.io.InputStream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.core.io.ClassPathResource;

public class SafeValidator
implements ConstraintValidator<Safe, String> {
    private static final Policy POLICY;

    public void initialize(Safe constraintAnnotation) {
    }

    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        return StringUtils.isBlank((CharSequence)s) || this.isSafe(s);
    }

    public boolean isSafe(String value) {
        AntiSamy antiSamy = new AntiSamy();
        try {
            CleanResults cleanResults = antiSamy.scan(value, POLICY);
            return cleanResults.getNumberOfErrors() <= 0;
        }
        catch (PolicyException | ScanException e) {
            return false;
        }
    }

    public static String getSafeStr(String value) {
        AntiSamy antiSamy = new AntiSamy();
        try {
            CleanResults cleanResults = antiSamy.scan(value, POLICY);
            return cleanResults.getCleanHTML();
        }
        catch (PolicyException | ScanException e) {
            return "";
        }
    }

    static {
        ClassPathResource resource = new ClassPathResource("antisamy.xml");
        try (InputStream is = resource.getInputStream();){
            POLICY = Policy.getInstance((InputStream)is);
        }
        catch (Exception e) {
            throw new CoreException((IResultCode)ResultCode.ANTISAMY_DATA_INIT_FAILED, (Throwable)e);
        }
    }
}

