/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.validator;

import com.lmaye.starter.data.web.validator.constraints.UserName;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.logging.log4j.util.Strings;

public class UserNameValidator
implements ConstraintValidator<UserName, String> {
    private static final Pattern USERNAME_PATTERN = Pattern.compile("(?!_)\\w{2,32}");

    public static boolean isUsername(String username) {
        return USERNAME_PATTERN.matcher(username).matches();
    }

    public void initialize(UserName constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return Strings.isBlank((String)value) || UserNameValidator.isUsername(value);
    }
}

