/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.web.config;

import com.lmaye.starter.data.web.WebProperties;
import com.lmaye.starter.data.web.context.ResultVO;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
@ConditionalOnProperty(value={"i18n.enabled"}, prefix="web", havingValue="true")
public class I18nMessageAdvice
implements ResponseBodyAdvice<Object> {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private WebProperties webProperties;

    public boolean supports(MethodParameter methodParam, Class<? extends HttpMessageConverter<?>> clazz) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParam, MediaType mediaType, Class<? extends HttpMessageConverter<?>> clazz, ServerHttpRequest request, ServerHttpResponse response) {
        if (MediaType.APPLICATION_JSON.equals((Object)mediaType) && body instanceof ResultVO) {
            ResultVO rs = (ResultVO)body;
            try {
                String[] split;
                HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
                WebProperties.I18n i18n = this.webProperties.getI18n();
                String localeName = servletRequest.getParameter(i18n.getLocaleName());
                Locale locale = StringUtils.isNotBlank((CharSequence)localeName) ? ((split = localeName.split(i18n.getLocaleDelimiter())).length == 2 ? new Locale(split[0], split[1]) : Locale.SIMPLIFIED_CHINESE) : LocaleContextHolder.getLocale();
                rs.setMsg(this.messageSource.getMessage(rs.getMsg(), null, locale));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return rs;
        }
        return body;
    }
}

