/*
 * Distributed as part of mchange-commons-java 0.2.11
 *
 * Copyright (C) 2015 Machinery For Change, Inc.
 *
 * Author: Steve Waldman <swaldman@mchange.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of EITHER:
 *
 *     1) The GNU Lesser General Public License (LGPL), version 2.1, as 
 *        published by the Free Software Foundation
 *
 * OR
 *
 *     2) The Eclipse Public License (EPL), version 1.0
 *
 * You may choose which license to accept if you wish to redistribute
 * or modify this work. You may offer derivatives of this work
 * under the license you have chosen, or you may provide the same
 * choice of license which you have been offered here.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received copies of both LGPL v2.1 and EPL v1.0
 * along with this software; see the files LICENSE-EPL and LICENSE-LGPL.
 * If not, the text of these licenses are currently available at
 *
 * LGPL v2.1: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html
 *  EPL v1.0: http://www.eclipse.org/org/documents/epl-v10.php 
 * 
 */

package com.mchange.v1.db.sql;

import java.sql.*;
import com.mchange.v1.util.BrokenObjectException;

public class ConnectionBundlePoolBean implements ConnectionBundlePool
{
    ConnectionBundlePool inner;

    public void init(String jdbcDriverClass, 
		     String jdbcUrl, String username, String pwd, 
		     int start, int max, int inc)
	throws SQLException, ClassNotFoundException
    {
	Class.forName( jdbcDriverClass );
	this.init(jdbcUrl, username, pwd, start, max, inc);
    }

    public void init(String jdbcUrl, String username, String pwd, int start, int max, int inc)
	throws SQLException
    {
	this.inner = new InnerPool(jdbcUrl, username, pwd, start, max, inc);
    }

    public ConnectionBundle checkoutBundle() 
	throws SQLException, InterruptedException, BrokenObjectException
    { return inner.checkoutBundle(); }
	
    public void checkinBundle(ConnectionBundle bndl) throws SQLException, BrokenObjectException
    { inner.checkinBundle(bndl); }
	
    public void close() throws SQLException
    { inner.close(); }

    protected void setConnectionOptions(Connection con) throws SQLException
    { con.setAutoCommit( false ); }

    class InnerPool extends ConnectionBundlePoolImpl
    {
	InnerPool(String jdbcUrl, String username, String pwd, int start, int max, int inc)
	    throws SQLException
	{
	    super(start, max, inc);

	    //ConnectionBundlePoolBean.this is not set until
	    //after superconstructor has completed, so we must
	    //put off init()
	    this.init(jdbcUrl, username, pwd);
	}
	
	protected void setConnectionOptions(Connection con) throws SQLException
	    { ConnectionBundlePoolBean.this.setConnectionOptions( con ); }
    }
}
