/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.bitmap;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.WrappedConciseBitmap;
import com.metamx.collections.bitmap.WrappedImmutableConciseBitmap;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ConciseBitmapFactory
implements BitmapFactory {
    private static final ImmutableConciseSet EMPTY_IMMUTABLE_BITMAP = new ImmutableConciseSet();
    private static final WrappedImmutableConciseBitmap WRAPPED_IMMUTABLE_CONCISE_BITMAP = new WrappedImmutableConciseBitmap(EMPTY_IMMUTABLE_BITMAP);

    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedConciseBitmap();
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return WRAPPED_IMMUTABLE_CONCISE_BITMAP;
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedConciseBitmap)) {
            throw new IllegalStateException(String.format("Cannot convert [%s]", mutableBitmap.getClass()));
        }
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)((WrappedConciseBitmap)mutableBitmap).getBitmap()));
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedImmutableConciseBitmap(b);
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) throws ClassCastException {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.union(ConciseBitmapFactory.unwrap(b)));
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) throws ClassCastException {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.intersection(ConciseBitmapFactory.unwrap(b)));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b) {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.complement((ImmutableConciseSet)((WrappedImmutableConciseBitmap)b).getBitmap()));
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.complement((ImmutableConciseSet)((WrappedImmutableConciseBitmap)b).getBitmap(), (int)length));
    }

    private static Iterable<ImmutableConciseSet> unwrap(final Iterable<ImmutableBitmap> b) {
        return new Iterable<ImmutableConciseSet>(){

            @Override
            public Iterator<ImmutableConciseSet> iterator() {
                final Iterator i = b.iterator();
                return new Iterator<ImmutableConciseSet>(){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public ImmutableConciseSet next() {
                        WrappedImmutableConciseBitmap wrappedBitmap = (WrappedImmutableConciseBitmap)i.next();
                        if (wrappedBitmap == null) {
                            return EMPTY_IMMUTABLE_BITMAP;
                        }
                        return wrappedBitmap.getBitmap();
                    }
                };
            }
        };
    }
}

