/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.mybatisflex.core.handler.BaseJsonTypeHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class Fastjson2TypeHandler
extends BaseJsonTypeHandler<Object> {
    private final Class<?> propertyType;
    private Class<?> genericType;
    private Type type;
    private boolean supportAutoType = false;

    public Fastjson2TypeHandler(Class<?> propertyType) {
        this.propertyType = propertyType;
        this.supportAutoType = propertyType.isInterface() || Modifier.isAbstract(propertyType.getModifiers());
    }

    public Fastjson2TypeHandler(Class<?> propertyType, Class<?> genericType) {
        this.propertyType = propertyType;
        this.genericType = genericType;
        this.type = TypeReference.collectionType(propertyType, genericType);
        Type actualTypeArgument = ((ParameterizedType)this.type).getActualTypeArguments()[0];
        if (actualTypeArgument instanceof Class) {
            this.supportAutoType = ((Class)actualTypeArgument).isInterface() || Modifier.isAbstract(((Class)actualTypeArgument).getModifiers());
        }
    }

    @Override
    protected Object parseJson(String json) {
        if (this.genericType != null && Collection.class.isAssignableFrom(this.propertyType)) {
            if (this.supportAutoType) {
                return JSON.parseArray((String)json, Object.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
            }
            return JSON.parseObject((String)json, (Type)this.type);
        }
        if (this.supportAutoType) {
            return JSON.parseObject((String)json, Object.class, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
        }
        return JSON.parseObject((String)json, this.propertyType);
    }

    @Override
    protected String toJson(Object object) {
        if (this.supportAutoType) {
            return JSON.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty, JSONWriter.Feature.WriteNullStringAsEmpty, JSONWriter.Feature.WriteClassName});
        }
        return JSON.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty, JSONWriter.Feature.WriteNullStringAsEmpty});
    }
}

