/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.mybatis.MappedStatementTypes;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class RowMapperInvoker {
    private final SqlSessionFactory sqlSessionFactory;

    public RowMapperInvoker(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    /*
     * Loose catch block
     */
    protected <R> R execute(Function<RowMapper, R> function) {
        Class<?> currentType = MappedStatementTypes.getCurrentType();
        if (currentType == null) {
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
                RowMapper mapper = (RowMapper)sqlSession.getMapper(RowMapper.class);
                R r = function.apply(mapper);
                return r;
            }
        }
        MappedStatementTypes.clear();
        try {
            R r;
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
                RowMapper mapper = (RowMapper)sqlSession.getMapper(RowMapper.class);
                r = function.apply(mapper);
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            MappedStatementTypes.setCurrentType(currentType);
        }
    }

    public int insert(String schema, String tableName, Row row) {
        return this.execute(mapper -> mapper.insert(schema, tableName, row));
    }

    public int insertBySql(String sql, Object ... args) {
        return this.execute(mapper -> mapper.insertBySql(sql, args));
    }

    public int insertBatchWithFirstRowColumns(String schema, String tableName, List<Row> rows) {
        return this.execute(mapper -> mapper.insertBatchWithFirstRowColumns(schema, tableName, rows));
    }

    public int deleteBySql(String sql, Object ... args) {
        return this.execute(mapper -> mapper.deleteBySql(sql, args));
    }

    public int deleteById(String schema, String tableName, Row row) {
        return this.execute(mapper -> mapper.deleteById(schema, tableName, row));
    }

    public int deleteById(String schema, String tableName, String primaryKey, Object id) {
        return this.execute(mapper -> mapper.deleteById(schema, tableName, primaryKey, id));
    }

    public int deleteBatchByIds(String schema, String tableName, String primaryKey, Collection<?> ids) {
        return this.execute(mapper -> mapper.deleteBatchByIds(schema, tableName, primaryKey, ids));
    }

    public int deleteByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.deleteByQuery(schema, tableName, queryWrapper));
    }

    public int updateBySql(String sql, Object ... args) {
        return this.execute(mapper -> mapper.updateBySql(sql, args));
    }

    public <M, E> int[] executeBatch(Collection<E> datas, int batchSize, Class<M> mapperClass, BiConsumer<M, E> consumer) {
        int[] results = new int[datas.size()];
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, true);){
            Object mapper = sqlSession.getMapper(mapperClass);
            int counter = 0;
            int resultsPos = 0;
            for (E data : datas) {
                consumer.accept(mapper, data);
                if (++counter != batchSize) continue;
                counter = 0;
                List batchResults = sqlSession.flushStatements();
                for (BatchResult batchResult : batchResults) {
                    int[] updateCounts;
                    for (int updateCount : updateCounts = batchResult.getUpdateCounts()) {
                        results[resultsPos++] = updateCount;
                    }
                }
            }
            if (counter != 0) {
                List batchResults = sqlSession.flushStatements();
                for (BatchResult batchResult : batchResults) {
                    int[] updateCounts;
                    for (int updateCount : updateCounts = batchResult.getUpdateCounts()) {
                        results[resultsPos++] = updateCount;
                    }
                }
            }
        }
        return results;
    }

    public <M> int[] executeBatch(int totalSize, int batchSize, Class<M> mapperClass, BiConsumer<M, Integer> consumer) {
        int[] results = new int[totalSize];
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, true);){
            Object mapper = sqlSession.getMapper(mapperClass);
            int counter = 0;
            int resultsPos = 0;
            for (int i = 0; i < totalSize; ++i) {
                consumer.accept(mapper, i);
                if (++counter != batchSize) continue;
                counter = 0;
                List batchResults = sqlSession.flushStatements();
                for (BatchResult batchResult : batchResults) {
                    int[] updateCounts;
                    int[] nArray = updateCounts = batchResult.getUpdateCounts();
                    int n = nArray.length;
                    for (int j = 0; j < n; ++j) {
                        int updateCount = nArray[j];
                        results[resultsPos++] = updateCount;
                    }
                }
            }
            if (counter != 0) {
                List batchResults = sqlSession.flushStatements();
                for (BatchResult batchResult : batchResults) {
                    int[] updateCounts;
                    for (int updateCount : updateCounts = batchResult.getUpdateCounts()) {
                        results[resultsPos++] = updateCount;
                    }
                }
            }
        }
        return results;
    }

    public int updateById(String schema, String tableName, Row row) {
        return this.execute(mapper -> mapper.updateById(schema, tableName, row));
    }

    public int updateByQuery(String schema, String tableName, Row data, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.updateByQuery(schema, tableName, data, queryWrapper));
    }

    public int updateBatchById(String schema, String tableName, List<Row> rows) {
        return this.execute(mapper -> mapper.updateBatchById(schema, tableName, rows));
    }

    public Row selectOneBySql(String sql, Object ... args) {
        return this.execute(mapper -> mapper.selectOneBySql(sql, args));
    }

    public Row selectOneById(String schema, String tableName, Row row) {
        return this.execute(mapper -> mapper.selectOneById(schema, tableName, row));
    }

    public Row selectOneById(String schema, String tableName, String primaryKey, Object id) {
        return this.execute(mapper -> mapper.selectOneById(schema, tableName, primaryKey, id));
    }

    public Row selectOneByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.selectOneByQuery(schema, tableName, queryWrapper));
    }

    public List<Row> selectListBySql(String sql, Object ... args) {
        return this.execute(mapper -> mapper.selectListBySql(sql, args));
    }

    public List<Row> selectListByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.selectListByQuery(schema, tableName, queryWrapper));
    }

    public List<Row> selectAll(String schema, String tableName) {
        return this.execute(mapper -> mapper.selectAll(schema, tableName));
    }

    public Map selectFirstAndSecondColumnsAsMapByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.selectFirstAndSecondColumnsAsMapByQuery(schema, tableName, queryWrapper));
    }

    public Map selectFirstAndSecondColumnsAsMap(String sql, Object ... args) {
        return this.execute(mapper -> mapper.selectFirstAndSecondColumnsAsMap(sql, args));
    }

    public Object selectObjectByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.selectObjectByQuery(schema, tableName, queryWrapper));
    }

    public List<Object> selectObjectListByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.selectObjectListByQuery(schema, tableName, queryWrapper));
    }

    public Object selectObject(String sql, Object ... args) {
        return this.execute(mapper -> mapper.selectObject(sql, args));
    }

    public List<Object> selectObjectList(String sql, Object ... args) {
        return this.execute(mapper -> mapper.selectObjectList(sql, args));
    }

    public long selectCount(String sql, Object ... args) {
        return this.execute(mapper -> mapper.selectCount(sql, args));
    }

    public long selectCountByQuery(String schema, String tableName, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.selectCountByQuery(schema, tableName, queryWrapper));
    }

    public Page<Row> paginate(String schema, String tableName, Page<Row> page, QueryWrapper queryWrapper) {
        return this.execute(mapper -> mapper.paginate(schema, tableName, page, queryWrapper));
    }
}

