/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.core.dialect.OperateType;
import com.mybatisflex.core.table.DynamicSchemaProcessor;
import com.mybatisflex.core.table.DynamicTableProcessor;
import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class TableManager {
    private static DynamicTableProcessor dynamicTableProcessor;
    private static DynamicSchemaProcessor dynamicSchemaProcessor;
    private static final ThreadLocal<Map<String, String>> tableNameMappingTL;
    private static final ThreadLocal<Map<String, String>> schemaMappingTL;

    private TableManager() {
    }

    public static DynamicTableProcessor getDynamicTableProcessor() {
        return dynamicTableProcessor;
    }

    public static void setDynamicTableProcessor(DynamicTableProcessor dynamicTableProcessor) {
        TableManager.dynamicTableProcessor = dynamicTableProcessor;
    }

    public static DynamicSchemaProcessor getDynamicSchemaProcessor() {
        return dynamicSchemaProcessor;
    }

    public static void setDynamicSchemaProcessor(DynamicSchemaProcessor dynamicSchemaProcessor) {
        TableManager.dynamicSchemaProcessor = dynamicSchemaProcessor;
    }

    public static void setHintTableMapping(String tableName, String mappingTable) {
        Map<String, String> hintTables = tableNameMappingTL.get();
        if (hintTables == null) {
            hintTables = new HashMap<String, String>();
            tableNameMappingTL.set(hintTables);
        }
        hintTables.put(tableName, mappingTable);
    }

    public static String getHintTableMapping(String tableName) {
        return tableNameMappingTL.get().get(tableName);
    }

    public static void setHintSchemaMapping(String schema, String mappingSchema) {
        Map<String, String> hintTables = schemaMappingTL.get();
        if (hintTables == null) {
            hintTables = new HashMap<String, String>();
            schemaMappingTL.set(hintTables);
        }
        hintTables.put(schema, mappingSchema);
    }

    public static String getHintSchemaMapping(String schema) {
        return schemaMappingTL.get().get(schema);
    }

    public static String getRealTable(String tableName, OperateType operateType) {
        String dynamicTableName;
        Map<String, String> mapping = tableNameMappingTL.get();
        if (mapping != null && StringUtil.hasText(dynamicTableName = mapping.get(tableName))) {
            return dynamicTableName;
        }
        if (dynamicTableProcessor == null) {
            return tableName;
        }
        dynamicTableName = dynamicTableProcessor.process(tableName, operateType);
        return StringUtil.hasText(dynamicTableName) ? dynamicTableName : tableName;
    }

    public static String getRealSchema(String schema, String table, OperateType operateType) {
        String dynamicSchema;
        Map<String, String> mapping = schemaMappingTL.get();
        if (mapping != null && StringUtil.hasText(dynamicSchema = mapping.get(schema))) {
            return dynamicSchema;
        }
        if (dynamicSchemaProcessor == null) {
            return schema;
        }
        dynamicSchema = dynamicSchemaProcessor.process(schema, table, operateType);
        return StringUtil.hasText(dynamicSchema) ? dynamicSchema : schema;
    }

    public static void clear() {
        tableNameMappingTL.remove();
        schemaMappingTL.remove();
    }

    static {
        tableNameMappingTL = new ThreadLocal();
        schemaMappingTL = new ThreadLocal();
    }
}

