/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.OperateType;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.ArithmeticQueryColumn;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.Conditional;
import com.mybatisflex.core.query.QueryColumnBehavior;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public class QueryColumn
implements CloneSupport<QueryColumn>,
Conditional<QueryCondition> {
    protected QueryTable table;
    protected String name;
    protected String alias;
    private boolean returnCopyByAsMethod = false;

    public QueryColumn() {
    }

    public QueryColumn(String name) {
        SqlUtil.keepColumnSafely(name);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
        this.alias = StringUtil.tryTrim(alias);
    }

    public QueryColumn(QueryTable queryTable, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = queryTable;
        this.name = StringUtil.tryTrim(name);
        this.returnCopyByAsMethod = true;
    }

    public QueryColumn(QueryTable queryTable, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = queryTable;
        this.name = StringUtil.tryTrim(name);
        this.alias = StringUtil.tryTrim(alias);
    }

    public QueryTable getTable() {
        return this.table;
    }

    public void setTable(QueryTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public <T> QueryColumn as(LambdaGetter<T> fn) {
        return this.as(fn, false);
    }

    public <T> QueryColumn as(LambdaGetter<T> fn, boolean withPrefix) {
        return this.as(LambdaUtil.getAliasName(fn, withPrefix));
    }

    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        if (this.returnCopyByAsMethod) {
            QueryColumn newColumn = new QueryColumn();
            newColumn.table = this.table;
            newColumn.name = this.name;
            newColumn.alias = alias;
            return newColumn;
        }
        this.alias = alias;
        return this;
    }

    QueryCondition eq_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.EQUALS, value));
    }

    @Override
    public QueryCondition eq(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.eq_(value);
    }

    @Override
    public QueryCondition eq(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.eq_(value);
    }

    @Override
    public QueryCondition eq(Object value, BooleanSupplier isEffective) {
        return this.eq(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition eq(T value, Predicate<T> isEffective) {
        return this.eq(value, isEffective.test(value));
    }

    QueryCondition ne_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_EQUALS, value));
    }

    @Override
    public QueryCondition ne(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.ne_(value);
    }

    @Override
    public QueryCondition ne(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.ne_(value);
    }

    @Override
    public QueryCondition ne(Object value, BooleanSupplier isEffective) {
        return this.ne(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition ne(T value, Predicate<T> isEffective) {
        return this.ne(value, isEffective.test(value));
    }

    QueryCondition gt_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.GT, value));
    }

    @Override
    public QueryCondition gt(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.gt_(value);
    }

    @Override
    public QueryCondition gt(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.gt_(value);
    }

    @Override
    public QueryCondition gt(Object value, BooleanSupplier isEffective) {
        return this.gt(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition gt(T value, Predicate<T> isEffective) {
        return this.gt(value, isEffective.test(value));
    }

    QueryCondition ge_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.GE, value));
    }

    @Override
    public QueryCondition ge(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.ge_(value);
    }

    @Override
    public QueryCondition ge(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.ge_(value);
    }

    @Override
    public QueryCondition ge(Object value, BooleanSupplier isEffective) {
        return this.ge(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition ge(T value, Predicate<T> isEffective) {
        return this.ge(value, isEffective.test(value));
    }

    QueryCondition lt_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.LT, value));
    }

    @Override
    public QueryCondition lt(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.lt_(value);
    }

    @Override
    public QueryCondition lt(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.lt_(value);
    }

    @Override
    public QueryCondition lt(Object value, BooleanSupplier isEffective) {
        return this.lt(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition lt(T value, Predicate<T> isEffective) {
        return this.lt(value, isEffective.test(value));
    }

    QueryCondition le_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.LE, value));
    }

    @Override
    public QueryCondition le(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.le_(value);
    }

    @Override
    public QueryCondition le(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.le_(value);
    }

    @Override
    public QueryCondition le(Object value, BooleanSupplier isEffective) {
        return this.le(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition le(T value, Predicate<T> isEffective) {
        return this.le(value, isEffective.test(value));
    }

    QueryCondition in_(Object ... value) {
        if (value.length == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.EQUALS, value[0]));
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " IN ", (Object)value));
    }

    @Override
    public QueryCondition in(Object ... value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.in_(value);
    }

    @Override
    public QueryCondition in(Object[] value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.in_(value);
    }

    @Override
    public QueryCondition in(Object[] value, BooleanSupplier isEffective) {
        return this.in(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition in(T[] value, Predicate<T[]> isEffective) {
        return this.in((Object[])value, isEffective.test(value));
    }

    QueryCondition in_(Collection<?> value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " IN ", value));
    }

    @Override
    public QueryCondition in(Collection<?> value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.in_(value);
    }

    @Override
    public QueryCondition in(Collection<?> value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.in_(value);
    }

    @Override
    public QueryCondition in(Collection<?> value, BooleanSupplier isEffective) {
        return this.in((Collection)value, isEffective.getAsBoolean());
    }

    @Override
    public <T extends Collection<?>> QueryCondition in(T value, Predicate<T> isEffective) {
        return this.in((Collection)value, isEffective.test(value));
    }

    QueryCondition in_(QueryWrapper queryWrapper) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " IN ", (Object)queryWrapper));
    }

    @Override
    public QueryCondition in(QueryWrapper queryWrapper) {
        if (QueryColumnBehavior.shouldIgnoreValue(queryWrapper)) {
            return QueryCondition.createEmpty();
        }
        return this.in_(queryWrapper);
    }

    @Override
    public QueryCondition in(QueryWrapper queryWrapper, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.in_(queryWrapper);
    }

    @Override
    public QueryCondition in(QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        return this.in(queryWrapper, isEffective.getAsBoolean());
    }

    QueryCondition notIn_(Object ... value) {
        if (value.length == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_EQUALS, value[0]));
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " NOT IN ", (Object)value));
    }

    @Override
    public QueryCondition notIn(Object ... value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.notIn_(value);
    }

    @Override
    public QueryCondition notIn(Object[] value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notIn_(value);
    }

    @Override
    public QueryCondition notIn(Object[] value, BooleanSupplier isEffective) {
        return this.notIn(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition notIn(T[] value, Predicate<T[]> isEffective) {
        return this.notIn((Object[])value, isEffective.test(value));
    }

    QueryCondition notIn_(Collection<?> value) {
        if (value.size() == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            Object next = value.iterator().next();
            return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_EQUALS, next));
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " NOT IN ", value));
    }

    @Override
    public QueryCondition notIn(Collection<?> value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.notIn_(value);
    }

    @Override
    public QueryCondition notIn(Collection<?> value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notIn_(value);
    }

    @Override
    public QueryCondition notIn(Collection<?> value, BooleanSupplier isEffective) {
        return this.notIn((Collection)value, isEffective.getAsBoolean());
    }

    @Override
    public <T extends Collection<?>> QueryCondition notIn(T value, Predicate<T> isEffective) {
        return this.notIn((Collection)value, isEffective.test(value));
    }

    QueryCondition notIn_(QueryWrapper queryWrapper) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " NOT IN ", (Object)queryWrapper));
    }

    @Override
    public QueryCondition notIn(QueryWrapper queryWrapper) {
        if (QueryColumnBehavior.shouldIgnoreValue(queryWrapper)) {
            return QueryCondition.createEmpty();
        }
        return this.notIn_(queryWrapper);
    }

    @Override
    public QueryCondition notIn(QueryWrapper queryWrapper, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notIn_(queryWrapper);
    }

    @Override
    public QueryCondition notIn(QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        return this.notIn(queryWrapper, isEffective.getAsBoolean());
    }

    QueryCondition between_(Object[] values) {
        if (values == null || values.length != 2) {
            throw new IllegalArgumentException("values is null or length is not 2");
        }
        Object start = values[0];
        Object end = values[1];
        return this.between_(start, end);
    }

    QueryCondition between_(Object start, Object end) {
        if (start == null && end == null) {
            return QueryCondition.createEmpty();
        }
        boolean smartConvertBetweenToLeOrGe = QueryColumnBehavior.isSmartConvertBetweenToLeOrGe();
        if (!(start != null && end != null || smartConvertBetweenToLeOrGe)) {
            return QueryCondition.createEmpty();
        }
        if (start == null) {
            return this.le_(end);
        }
        if (end == null) {
            return this.ge_(start);
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " BETWEEN ", (Object)new Object[]{start, end}));
    }

    @Override
    public QueryCondition between(Object[] values) {
        return this.between_(values);
    }

    @Override
    public QueryCondition between(Object[] values, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.between_(values);
    }

    @Override
    public QueryCondition between(Object start, Object end) {
        return this.between_(start, end);
    }

    @Override
    public QueryCondition between(Object start, Object end, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.between_(start, end);
    }

    @Override
    public QueryCondition between(Object start, Object end, BooleanSupplier isEffective) {
        return this.between(start, end, isEffective.getAsBoolean());
    }

    @Override
    public <S, E> QueryCondition between(S start, E end, BiPredicate<S, E> isEffective) {
        return this.between(start, end, isEffective.test(start, end));
    }

    QueryCondition notBetween_(Object[] values) {
        if (values == null || values.length != 2) {
            throw new IllegalArgumentException("values is null or length is not 2");
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " NOT BETWEEN ", (Object)values));
    }

    QueryCondition notBetween_(Object start, Object end) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, " NOT BETWEEN ", (Object)new Object[]{start, end}));
    }

    @Override
    public QueryCondition notBetween(Object[] values) {
        return this.notBetween_(values);
    }

    @Override
    public QueryCondition notBetween(Object[] values, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notBetween_(values);
    }

    @Override
    public QueryCondition notBetween(Object start, Object end) {
        return this.notBetween_(start, end);
    }

    @Override
    public QueryCondition notBetween(Object start, Object end, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notBetween_(start, end);
    }

    @Override
    public QueryCondition notBetween(Object start, Object end, BooleanSupplier isEffective) {
        return this.notBetween(start, end, isEffective.getAsBoolean());
    }

    @Override
    public <S, E> QueryCondition notBetween(S start, E end, BiPredicate<S, E> isEffective) {
        return this.notBetween(start, end, isEffective.test(start, end));
    }

    QueryCondition like_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value + "%")));
    }

    @Override
    public QueryCondition like(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.like_(value);
    }

    @Override
    public QueryCondition like(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.like_(value);
    }

    @Override
    public QueryCondition like(Object value, BooleanSupplier isEffective) {
        return this.like(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition like(T value, Predicate<T> isEffective) {
        return this.like(value, isEffective.test(value));
    }

    QueryCondition likeLeft_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.LIKE, (Object)(value + "%")));
    }

    @Override
    public QueryCondition likeLeft(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeLeft_(value);
    }

    @Override
    public QueryCondition likeLeft(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.likeLeft_(value);
    }

    @Override
    public QueryCondition likeLeft(Object value, BooleanSupplier isEffective) {
        return this.likeLeft(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition likeLeft(T value, Predicate<T> isEffective) {
        return this.likeLeft(value, isEffective.test(value));
    }

    QueryCondition likeRight_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.LIKE, (Object)("%" + value)));
    }

    @Override
    public QueryCondition likeRight(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRight_(value);
    }

    @Override
    public QueryCondition likeRight(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.likeRight_(value);
    }

    @Override
    public QueryCondition likeRight(Object value, BooleanSupplier isEffective) {
        return this.likeRight(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition likeRight(T value, Predicate<T> isEffective) {
        return this.likeRight(value, isEffective.test(value));
    }

    QueryCondition likeRaw_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.LIKE, value));
    }

    public QueryCondition likeRaw(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw_(value);
    }

    public QueryCondition likeRaw(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.likeRaw_(value);
    }

    public QueryCondition likeRaw(Object value, BooleanSupplier isEffective) {
        return this.likeRaw(value, isEffective.getAsBoolean());
    }

    public <T> QueryCondition likeRaw(T value, Predicate<T> isEffective) {
        return this.likeRaw(value, isEffective.test(value));
    }

    QueryCondition notLike_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value + "%")));
    }

    @Override
    public QueryCondition notLike(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.notLike_(value);
    }

    @Override
    public QueryCondition notLike(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notLike_(value);
    }

    @Override
    public QueryCondition notLike(Object value, BooleanSupplier isEffective) {
        return this.notLike(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition notLike(T value, Predicate<T> isEffective) {
        return this.notLike(value, isEffective.test(value));
    }

    QueryCondition notLikeLeft_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)(value + "%")));
    }

    @Override
    public QueryCondition notLikeLeft(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.notLikeLeft_(value);
    }

    @Override
    public QueryCondition notLikeLeft(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notLikeLeft_(value);
    }

    @Override
    public QueryCondition notLikeLeft(Object value, BooleanSupplier isEffective) {
        return this.notLikeLeft(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition notLikeLeft(T value, Predicate<T> isEffective) {
        return this.notLikeLeft(value, isEffective.test(value));
    }

    QueryCondition notLikeRight_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_LIKE, (Object)("%" + value)));
    }

    @Override
    public QueryCondition notLikeRight(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.notLikeRight_(value);
    }

    @Override
    public QueryCondition notLikeRight(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notLikeRight_(value);
    }

    @Override
    public QueryCondition notLikeRight(Object value, BooleanSupplier isEffective) {
        return this.notLikeRight(value, isEffective.getAsBoolean());
    }

    @Override
    public <T> QueryCondition notLikeRight(T value, Predicate<T> isEffective) {
        return this.notLikeRight(value, isEffective.test(value));
    }

    QueryCondition notLikeRaw_(Object value) {
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.NOT_LIKE, value));
    }

    public QueryCondition notLikeRaw(Object value) {
        if (QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return this.notLikeRaw_(value);
    }

    public QueryCondition notLikeRaw(Object value, boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return this.notLikeRaw_(value);
    }

    public QueryCondition notLikeRaw(Object value, BooleanSupplier isEffective) {
        return this.notLikeRaw(value, isEffective.getAsBoolean());
    }

    public <T> QueryCondition notLikeRaw(T value, Predicate<T> isEffective) {
        return this.notLikeRaw(value, isEffective.test(value));
    }

    @Override
    public QueryCondition isNull(boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.IS_NULL, null));
    }

    @Override
    public QueryCondition isNotNull(boolean isEffective) {
        if (!isEffective) {
            return QueryCondition.createEmpty();
        }
        return QueryColumnBehavior.castCondition(QueryCondition.create(this, SqlOperator.IS_NOT_NULL, null));
    }

    public QueryOrderBy asc() {
        return new QueryOrderBy(this, " ASC");
    }

    public QueryOrderBy desc() {
        return new QueryOrderBy(this, " DESC");
    }

    public QueryColumn add(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).add(queryColumn);
    }

    public QueryColumn add(Number number) {
        return new ArithmeticQueryColumn(this).add(number);
    }

    public QueryColumn subtract(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).subtract(queryColumn);
    }

    public QueryColumn subtract(Number number) {
        return new ArithmeticQueryColumn(this).subtract(number);
    }

    public QueryColumn multiply(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).multiply(queryColumn);
    }

    public QueryColumn multiply(Number number) {
        return new ArithmeticQueryColumn(this).multiply(number);
    }

    public QueryColumn divide(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).divide(queryColumn);
    }

    public QueryColumn divide(Number number) {
        return new ArithmeticQueryColumn(this).divide(number);
    }

    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        QueryTable selectTable = this.getSelectTable(queryTables, this.table);
        if (selectTable == null) {
            return dialect.wrap(this.name);
        }
        if (StringUtil.hasText(selectTable.alias)) {
            return dialect.wrap(selectTable.alias) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.hasText(selectTable.getSchema()) && StringUtil.hasText(selectTable.getName())) {
            String realTable = dialect.getRealTable(selectTable.getName(), OperateType.SELECT);
            return dialect.wrap(dialect.getRealSchema(selectTable.schema, realTable, OperateType.SELECT)) + "." + dialect.wrap(realTable) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.hasText(selectTable.getName())) {
            return dialect.wrap(dialect.getRealTable(selectTable.getName(), OperateType.SELECT)) + "." + dialect.wrap(this.name);
        }
        return dialect.wrap(this.name);
    }

    protected String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        return this.toConditionSql(queryTables, dialect) + WrapperUtil.buildColumnAlias(this.alias, dialect);
    }

    QueryTable getSelectTable(List<QueryTable> queryTables, QueryTable selfTable) {
        if (queryTables == null || queryTables.isEmpty()) {
            return null;
        }
        QueryTable consideredTable = queryTables.get(0);
        if (selfTable == null) {
            return consideredTable;
        }
        if (StringUtil.hasText(selfTable.alias)) {
            return selfTable;
        }
        if (queryTables.size() == 1 && Objects.equals(selfTable.name, consideredTable.name)) {
            return null;
        }
        consideredTable = selfTable;
        ListIterator<QueryTable> it = queryTables.listIterator(queryTables.size());
        while (it.hasPrevious()) {
            QueryTable queryTable = it.previous();
            if (!Objects.equals(queryTable.name, selfTable.name)) continue;
            if (StringUtil.noText(queryTable.alias)) {
                return queryTable;
            }
            consideredTable = queryTable;
        }
        return consideredTable;
    }

    public String toString() {
        return "QueryColumn{table=" + this.table + ", name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + '}';
    }

    @Override
    public QueryColumn clone() {
        try {
            QueryColumn clone = (QueryColumn)super.clone();
            clone.table = ObjectUtil.clone(this.table);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

