/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring;

import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.transaction.TransactionalManager;
import com.mybatisflex.core.util.StringUtil;
import com.mybatisflex.spring.TimeoutHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class FlexTransactionManager
extends AbstractPlatformTransactionManager {
    protected Object doGetTransaction() throws TransactionException {
        return new TransactionObject(TransactionContext.getXID());
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)((Object)transaction);
        return StringUtil.hasText((String)transactionObject.prevXid);
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        TransactionContext.release();
        TransactionObject transactionObject = (TransactionObject)((Object)transaction);
        return transactionObject.prevXid;
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        String xid = (String)suspendedResources;
        TransactionContext.holdXID((String)xid);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)((Object)transaction);
        transactionObject.currentXid = TransactionalManager.startTransactional();
        TimeoutHolder.hold(definition);
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)((Object)status.getTransaction());
        TransactionalManager.commit((String)transactionObject.currentXid);
        transactionObject.clear();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)((Object)status.getTransaction());
        TransactionalManager.rollback((String)transactionObject.currentXid);
        transactionObject.clear();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)((Object)status.getTransaction());
        transactionObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TimeoutHolder.clear();
    }

    static class TransactionObject
    extends JdbcTransactionObjectSupport {
        private static final ThreadLocal<String> ROLLBACK_ONLY_XIDS = new ThreadLocal();
        private final String prevXid;
        private String currentXid;

        public TransactionObject(String prevXid) {
            this.prevXid = prevXid;
        }

        public void setRollbackOnly() {
            ROLLBACK_ONLY_XIDS.set(this.prevXid);
        }

        public void clear() {
            ROLLBACK_ONLY_XIDS.remove();
        }

        public boolean isRollbackOnly() {
            return this.currentXid != null && this.currentXid.equals(ROLLBACK_ONLY_XIDS.get());
        }
    }
}

