/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.batch.builder;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.batch.MybatisFlexPagingItemReader;
import java.util.Optional;

public class MyBatisFlexPagingItemReaderBuilder<T> {
    private BaseMapper<T> mapper;
    private QueryWrapper queryWrapper;
    private Integer pageSize;
    private Boolean saveState;
    private Integer maxItemCount;

    public MyBatisFlexPagingItemReaderBuilder<T> mapper(BaseMapper<T> mapper) {
        this.mapper = mapper;
        return this;
    }

    public MyBatisFlexPagingItemReaderBuilder<T> queryWrapper(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
        return this;
    }

    public MyBatisFlexPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MyBatisFlexPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MyBatisFlexPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MybatisFlexPagingItemReader<T> build() {
        MybatisFlexPagingItemReader<T> reader = new MybatisFlexPagingItemReader<T>();
        reader.setMapper(this.mapper);
        reader.setQueryWrapper(this.queryWrapper);
        Optional.ofNullable(this.pageSize).ifPresent(arg_0 -> reader.setPageSize(arg_0));
        Optional.ofNullable(this.saveState).ifPresent(arg_0 -> reader.setSaveState(arg_0));
        Optional.ofNullable(this.maxItemCount).ifPresent(arg_0 -> reader.setMaxItemCount(arg_0));
        return reader;
    }
}

