/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.digest;

import com.mzlion.core.binary.Base64;
import com.mzlion.core.binary.Hex;
import com.mzlion.core.digest.DigestUtils;
import com.mzlion.core.exceptions.FatalDigestException;
import com.mzlion.core.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class MD5 {
    public static byte[] digest(byte[] data) {
        Assert.notEmpty(data, "The data is null or empty.");
        return DigestUtils.getMd5Digest().digest(data);
    }

    public static byte[] digest(InputStream data) {
        Assert.notNull(data, "The data is null.");
        try {
            return DigestUtils.digest(DigestUtils.getMd5Digest(), data);
        }
        catch (IOException e) {
            throw new FatalDigestException(e);
        }
    }

    public static String digestHex(String data) {
        return MD5.digestHex(data, StandardCharsets.UTF_8);
    }

    public static String digestHex(String data, Charset charset) {
        Assert.hasLength(data, "The data is null or empty.");
        byte[] salt = data.getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
        byte[] md5Data = MD5.digest(salt);
        return Hex.encode2String(md5Data);
    }

    public static String digestHex(InputStream data) {
        return Hex.encode2String(MD5.digest(data));
    }

    public static String digestBase64(String data) {
        return MD5.digestBase64(data, StandardCharsets.UTF_8);
    }

    public static String digestBase64(String data, Charset charset) {
        Assert.hasLength(data, "The data is null or empty.");
        byte[] salt = data.getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
        byte[] md5Data = MD5.digest(salt);
        return Base64.encode(md5Data);
    }
}

