/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

import com.mzlion.core.lang.StringUtils;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final Pattern MOBILE = Pattern.compile("1\\d{10}");
    public static final Pattern STRICT_MOBILE = Pattern.compile("1[34578]\\d{9}");
    public static final Pattern IPV4_REGEX = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)");
    public static final Pattern IPV6_REGEX = Pattern.compile("^([\\da-fA-F]{1,4}:){6}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^::([\\da-fA-F]{1,4}:){0,4}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:):([\\da-fA-F]{1,4}:){0,3}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){2}:([\\da-fA-F]{1,4}:){0,2}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){3}:([\\da-fA-F]{1,4}:){0,1}((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){4}:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$|^([\\da-fA-F]{1,4}:){7}[\\da-fA-F]{1,4}$|^:((:[\\da-fA-F]{1,4}){1,6}|:)$|^[\\da-fA-F]{1,4}:((:[\\da-fA-F]{1,4}){1,5}|:)$|^([\\da-fA-F]{1,4}:){2}((:[\\da-fA-F]{1,4}){1,4}|:)$|^([\\da-fA-F]{1,4}:){3}((:[\\da-fA-F]{1,4}){1,3}|:)$|^([\\da-fA-F]{1,4}:){4}((:[\\da-fA-F]{1,4}){1,2}|:)$|^([\\da-fA-F]{1,4}:){5}:([\\da-fA-F]{1,4})?$|^([\\da-fA-F]{1,4}:){6}:$");

    public static boolean isMobile(String mobile) {
        return ValidationUtils.isMatchRegex(MOBILE, mobile);
    }

    public static boolean isStrictMobile(String mobile) {
        return ValidationUtils.isMatchRegex(STRICT_MOBILE, mobile);
    }

    public static boolean isIPv4(String ip) {
        return ValidationUtils.isMatchRegex(IPV4_REGEX, ip);
    }

    public static boolean isIPv6(String ip) {
        return ValidationUtils.isMatchRegex(IPV6_REGEX, ip);
    }

    private static boolean isMatchRegex(Pattern pattern, String value) {
        if (pattern == null || StringUtils.isEmpty(value)) {
            return false;
        }
        return pattern.matcher(value).matches();
    }
}

