/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AbstractInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.internal.util.Archaius1Utils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public abstract class PropertiesInstanceConfig
extends AbstractInstanceConfig
implements EurekaInstanceConfig {
    protected final String namespace;
    protected final DynamicPropertyFactory configInstance;
    private String appGrpNameFromEnv;

    public PropertiesInstanceConfig() {
        this("eureka");
    }

    public PropertiesInstanceConfig(String namespace) {
        this(namespace, new DataCenterInfo(){

            @Override
            public DataCenterInfo.Name getName() {
                return DataCenterInfo.Name.MyOwn;
            }
        });
    }

    public PropertiesInstanceConfig(String namespace, DataCenterInfo info) {
        super(info);
        this.namespace = namespace.endsWith(".") ? namespace : namespace + ".";
        this.appGrpNameFromEnv = ConfigurationManager.getConfigInstance().getString("NETFLIX_APP_GROUP", "unknown");
        this.configInstance = Archaius1Utils.initConfig("eureka-client");
    }

    @Override
    public boolean isInstanceEnabledOnit() {
        return this.configInstance.getBooleanProperty(this.namespace + "traffic.enabled", super.isInstanceEnabledOnit()).get();
    }

    @Override
    public int getNonSecurePort() {
        return this.configInstance.getIntProperty(this.namespace + "port", super.getNonSecurePort()).get();
    }

    @Override
    public int getSecurePort() {
        return this.configInstance.getIntProperty(this.namespace + "securePort", super.getSecurePort()).get();
    }

    @Override
    public boolean isNonSecurePortEnabled() {
        return this.configInstance.getBooleanProperty(this.namespace + "port.enabled", super.isNonSecurePortEnabled()).get();
    }

    @Override
    public boolean getSecurePortEnabled() {
        return this.configInstance.getBooleanProperty(this.namespace + "securePort.enabled", super.getSecurePortEnabled()).get();
    }

    @Override
    public int getLeaseRenewalIntervalInSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "lease.renewalInterval", super.getLeaseRenewalIntervalInSeconds()).get();
    }

    @Override
    public int getLeaseExpirationDurationInSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "lease.duration", super.getLeaseExpirationDurationInSeconds()).get();
    }

    @Override
    public String getVirtualHostName() {
        if (this.isNonSecurePortEnabled()) {
            return this.configInstance.getStringProperty(this.namespace + "vipAddress", super.getVirtualHostName()).get();
        }
        return null;
    }

    @Override
    public String getSecureVirtualHostName() {
        if (this.getSecurePortEnabled()) {
            return this.configInstance.getStringProperty(this.namespace + "secureVipAddress", super.getSecureVirtualHostName()).get();
        }
        return null;
    }

    @Override
    public String getASGName() {
        return this.configInstance.getStringProperty(this.namespace + "asgName", super.getASGName()).get();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        String metadataNamespace = this.namespace + "metadata" + ".";
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        PropertiesInstanceConfig propertiesInstanceConfig = this;
        Configuration config = (Configuration)propertiesInstanceConfig.configInstance.getBackingConfigurationSource();
        String subsetPrefix = metadataNamespace.charAt(metadataNamespace.length() - 1) == '.' ? metadataNamespace.substring(0, metadataNamespace.length() - 1) : metadataNamespace;
        Iterator iter = config.subset(subsetPrefix).getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = config.getString(subsetPrefix + "." + key);
            metadataMap.put(key, value);
        }
        return metadataMap;
    }

    @Override
    public String getInstanceId() {
        String result = this.configInstance.getStringProperty(this.namespace + "instanceId", null).get();
        return result == null ? null : result.trim();
    }

    @Override
    public String getAppname() {
        return this.configInstance.getStringProperty(this.namespace + "name", "unknown").get().trim();
    }

    @Override
    public String getAppGroupName() {
        return this.configInstance.getStringProperty(this.namespace + "appGroup", this.appGrpNameFromEnv).get().trim();
    }

    @Override
    public String getIpAddress() {
        return super.getIpAddress();
    }

    @Override
    public String getStatusPageUrlPath() {
        return this.configInstance.getStringProperty(this.namespace + "statusPageUrlPath", "/Status").get();
    }

    @Override
    public String getStatusPageUrl() {
        return this.configInstance.getStringProperty(this.namespace + "statusPageUrl", null).get();
    }

    @Override
    public String getHomePageUrlPath() {
        return this.configInstance.getStringProperty(this.namespace + "homePageUrlPath", "/").get();
    }

    @Override
    public String getHomePageUrl() {
        return this.configInstance.getStringProperty(this.namespace + "homePageUrl", null).get();
    }

    @Override
    public String getHealthCheckUrlPath() {
        return this.configInstance.getStringProperty(this.namespace + "healthCheckUrlPath", "/healthcheck").get();
    }

    @Override
    public String getHealthCheckUrl() {
        return this.configInstance.getStringProperty(this.namespace + "healthCheckUrl", null).get();
    }

    @Override
    public String getSecureHealthCheckUrl() {
        return this.configInstance.getStringProperty(this.namespace + "secureHealthCheckUrl", null).get();
    }

    @Override
    public String[] getDefaultAddressResolutionOrder() {
        String result = this.configInstance.getStringProperty(this.namespace + "defaultAddressResolutionOrder", null).get();
        return result == null ? new String[]{} : result.split(",");
    }

    @Override
    public boolean shouldBroadcastPublicIpv4Addr() {
        return this.configInstance.getBooleanProperty(this.namespace + "broadcastPublicIpv4", super.shouldBroadcastPublicIpv4Addr()).get();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

