/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

public class NUMBER_FLOAT
extends Datum {
    private final float value;
    private BigDecimal bigDecimal = null;

    public NUMBER_FLOAT(float value) {
        this.value = value;
    }

    public NUMBER_FLOAT(float value, byte[] bytes) {
        super(bytes);
        this.value = value;
        if (bytes != null) {
            this.bigDecimal = new BigDecimal(new String(bytes));
        }
    }

    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(String.valueOf(this.value).getBytes(StandardCharsets.UTF_8));
    }

    public int getApproximateTextProtocolLength() {
        return String.valueOf(this.value).getBytes().length;
    }

    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.writeLong(Double.doubleToLongBits(this.value));
    }

    public ColumnType getColumnType() {
        return ColumnType.DOUBLE;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean isNullData() {
        return false;
    }

    public boolean isLongData() {
        return false;
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        String targetClassName = targetClass.getName();
        return targetClassName.compareTo("java.lang.Float") == 0 || targetClassName.compareTo("java.lang.Double") == 0;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.bigDecimal;
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        BigDecimal[] bigDecimals = new BigDecimal[intVal];
        return bigDecimals;
    }
}

