/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.Datum;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TIMESTAMPTZ
extends Datum {
    public TIMESTAMPTZ() {
        super(DataTypeUtilities.initTimestamptz());
    }

    public TIMESTAMPTZ(byte[] bytes) {
        super(bytes);
    }

    public TIMESTAMPTZ(Connection connection, Date date) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, date));
    }

    public TIMESTAMPTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, date, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Time time) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, time, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, timestamp));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar, boolean isTZTablesImported) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, timestamp, calendar, isTZTablesImported));
    }

    public TIMESTAMPTZ(Connection connection, String time) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, String time, Calendar calendar) throws SQLException {
        super(DataTypeUtilities.TIMESTAMPTZtoBytes(connection, time, calendar));
    }

    public static Date toDate(byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = DataTypeUtilities.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Calendar targetCalendar = Calendar.getInstance(TimeZone.getTimeZone(tzStr));
        Date date = new Date(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        targetCalendar.setTime(date);
        date.setTime(targetCalendar.getTime().getTime());
        return date;
    }

    public static Time toTime(Connection connection, byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = DataTypeUtilities.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Time time = new Time(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(tzStr), true));
        return time;
    }

    public static TIMESTAMP toTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestamp(protocol, bytes));
    }

    public static TIMESTAMP resultTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestamp(protocol, bytes, true));
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestamp(connection, bytes));
    }

    @Override
    public Date dateValue() throws SQLException {
        return TIMESTAMPTZ.toDate(this.getBytes());
    }

    public Date dateValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return TIMESTAMPTZ.toTime(null, this.getBytes());
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = DataTypeUtilities.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Timestamp timestamp = new Timestamp(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        timestamp.setNanos(DataTypeUtilities.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes, boolean isResult) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = DataTypeUtilities.toTimezoneStr(bytes[12], bytes[13], "GMT", isResult);
        Timestamp timestamp = null;
        timestamp = new Timestamp(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(tzStr), !isResult));
        timestamp.setNanos(DataTypeUtilities.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Connection connection, byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = DataTypeUtilities.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Timestamp timestamp = new Timestamp(DataTypeUtilities.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        timestamp.setNanos(DataTypeUtilities.getNanos(bytes, 7));
        return timestamp;
    }

    public String toResultSetString(Connection connection) throws SQLException {
        return DataTypeUtilities.TIMESTAMPTZToString(connection, this.getBytes(), true);
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTimestamp(connection, this.getBytes());
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMPTZ.toTimestamp((Connection)null, this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return DataTypeUtilities.TIMESTAMPTZToString(connection, this.getBytes(), false);
    }

    @Override
    public String stringValue() throws SQLException {
        return DataTypeUtilities.TIMESTAMPTZToString(null, this.getBytes(), false);
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTime(connection, this.getBytes());
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int temp) {
        Timestamp[] timestamps = new Timestamp[temp];
        return timestamps;
    }

    @Override
    public boolean isConvertibleTo(Class claz) {
        return claz.getName().compareTo("java.sql.Date") == 0 || claz.getName().compareTo("java.sql.Time") == 0 || claz.getName().compareTo("java.sql.Timestamp") == 0 || claz.getName().compareTo("java.lang.String") == 0;
    }

    private static int getHighOrderbits(int bits) {
        return (bits & 0x7F) << 6;
    }

    private static int getLowOrderbits(int bits) {
        return (bits & 0xFC) >> 2;
    }
}

