/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.Lob;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.LongDataParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class StreamParameter
implements Cloneable,
LongDataParameterHolder {
    private InputStream is;
    private final Lob lob;
    private final long length;
    private final boolean noBackslashEscapes;

    public StreamParameter(InputStream is, long length, boolean noBackslashEscapes) {
        this.is = is;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
        this.lob = null;
    }

    public StreamParameter(Lob lob, long length, boolean noBackslashEscapes) {
        this.lob = lob;
        this.is = null;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public StreamParameter(InputStream is, boolean noBackSlashEscapes) {
        this(is, Long.MAX_VALUE, noBackSlashEscapes);
    }

    private void setInputStream() throws IOException {
        if (this.lob != null) {
            try {
                this.is = this.lob.getBinaryStream();
            }
            catch (SQLException throwables) {
                IOException ioException = new IOException();
                ioException.initCause(throwables);
                throw ioException;
            }
        }
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        this.setInputStream();
        pos.write(BINARY_INTRODUCER);
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.is, true, this.noBackslashEscapes);
        } else {
            pos.write(this.is, this.length, true, this.noBackslashEscapes);
        }
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        this.setInputStream();
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.is, false, this.noBackslashEscapes);
        } else {
            pos.write(this.is, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public String toString() {
        return "<Stream>";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.BLOB;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return true;
    }

    @Override
    public boolean writePieceData(PacketOutputStream pos, boolean first, Options options) throws IOException {
        return false;
    }

    @Override
    public boolean writeLongData(PacketOutputStream writer, Options options, int statementId, short paramIndex) throws IOException {
        int len;
        this.setInputStream();
        byte[] buffer = new byte[8192];
        int totoalReadLen = 0;
        int currentPacketLen = 0;
        int lastReadLen = 0;
        boolean isEmpty = true;
        int sizeToSend = options.blobSendChunkSize;
        writer.startPacket(0);
        writer.write(24);
        writer.writeInt(statementId);
        writer.writeShort(paramIndex);
        while ((len = this.is.read(buffer)) != -1) {
            isEmpty = false;
            byte[] data = new byte[len];
            System.arraycopy(buffer, 0, data, 0, len);
            writer.write(data, 0, data.length);
            totoalReadLen += len;
            if ((currentPacketLen += len) < sizeToSend) continue;
            currentPacketLen = 0;
            lastReadLen = totoalReadLen;
            writer.flush();
            writer.startPacket(0);
            writer.write(24);
            writer.writeInt(statementId);
            writer.writeShort(paramIndex);
        }
        if (lastReadLen != totoalReadLen) {
            writer.flush();
        }
        if (isEmpty) {
            writer.flush();
        }
        return true;
    }
}

