/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol.flt;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.protocol.flt.FullLinkTrace;
import com.oceanbase.jdbc.internal.protocol.flt.ObObj;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class OceanBaseProtocolV20 {
    private static final int UINT_MAX24 = 0xFFFFFF;
    private static final int TYPE_LENGTH = 2;
    private static final int LEN_LENGTH = 4;
    public static final int COMPRESS_HEADER_LENGTH = 7;
    public static final int OB20_HEADER_LENGTH = 24;
    public static final int TOTAL_HEADER_LENGTH = 31;
    public static final int OB20_MAGIC_NUM = 8363;
    public static final int OB20_VERSION = 20;
    public static final int OB20_EXTRA_LENGTH = 4;
    public static final int MYSQL_PACKET_HEADER = 4;
    public static final int OB20_TAIL_LENGTH = 4;
    public static final int OB_EXTRA_INFO_EXIST = 1;
    public static final int OB_IS_LAST_PACKET = 2;
    public static final int OB_IS_PROXY_REROUTE = 4;
    public static final int OB_IS_NEW_EXTRA_INFO = 8;
    public Header header;
    public ExtraInfo extraInfo;
    public long tailChecksum;
    public FullLinkTrace.TraceInfo traceInfo;
    public int curRequestId;
    public short curObSeqNo;

    public OceanBaseProtocolV20(boolean useNewExtraInfo) {
        this.header = new Header(useNewExtraInfo);
        this.extraInfo = new ExtraInfo(useNewExtraInfo);
        this.curRequestId = new Random().nextInt(0xFFFFFF);
    }

    public void setTraceInfo(FullLinkTrace.TraceInfo traceInfo) {
        this.traceInfo = traceInfo;
    }

    public void reset() {
        this.header.reset();
        this.extraInfo.reset();
        this.tailChecksum = 0L;
    }

    public void updateRequestId() {
        ++this.curRequestId;
        if (this.curRequestId == 0x1000000) {
            this.curRequestId = 0;
        }
    }

    public short getObSeqNo() {
        this.curObSeqNo = (short)((this.curObSeqNo + 1) % 256);
        return this.curObSeqNo;
    }

    public void initObSeqNo(int seqNo) {
        this.curObSeqNo = (short)(seqNo - 1);
    }

    public boolean isExtraInfoExist() {
        return 1 == (this.header.flag & 1);
    }

    public void setExtraInfoLength() {
        long len = 0L;
        if (!this.extraInfo.useNewExtraInfo) {
            for (Map.Entry<ObObj, ObObj> entry : this.extraInfo.obobjMap.entrySet()) {
                len += entry.getKey().getSerializeSize();
                len += entry.getValue().getSerializeSize();
            }
        } else {
            for (Map.Entry<ExtraInfoKey, byte[]> entry : this.extraInfo.bytesMap.entrySet()) {
                len += (long)(6 + entry.getValue().length);
            }
        }
        this.extraInfo.extraLength = len;
    }

    public void setExtraInfo(ObObj key, ObObj value) {
        this.header.flag |= 1;
        this.extraInfo.obobjMap.put(key, value);
    }

    public void setExtraInfo(ExtraInfoKey key, byte[] valueData) {
        this.header.flag |= 1;
        this.extraInfo.bytesMap.put(key, valueData);
    }

    public byte[] getExtraInfoBytes() throws IOException {
        this.extraInfo.extraBytes = new byte[(int)this.extraInfo.extraLength];
        Buffer extra = new Buffer(this.extraInfo.extraBytes);
        if (!this.extraInfo.useNewExtraInfo) {
            for (Map.Entry<ObObj, ObObj> entry : this.extraInfo.obobjMap.entrySet()) {
                entry.getKey().serialize(extra);
                entry.getValue().serialize(extra);
            }
        } else {
            for (Map.Entry<ExtraInfoKey, byte[]> entry : this.extraInfo.bytesMap.entrySet()) {
                extra.writeShort(entry.getKey().getValue());
                extra.writeInt(entry.getValue().length);
                extra.writeBytes(entry.getValue(), 0, entry.getValue().length);
            }
        }
        return this.extraInfo.extraBytes;
    }

    public void analyseExtraInfoBytes() throws IOException {
        Buffer extra = new Buffer(this.extraInfo.extraBytes);
        if (!this.extraInfo.useNewExtraInfo) {
            while (extra.remaining() > 0) {
                ObObj keyObj = new ObObj();
                ObObj valueObj = new ObObj();
                keyObj.deserialize(extra);
                valueObj.deserialize(extra);
                if (!new String(keyObj.value.vStr).equalsIgnoreCase(ExtraInfoKey.FULL_TRC.name())) continue;
                Buffer buf = new Buffer(valueObj.value.vStr, valueObj.valueLen);
                this.decodeObFullLinkTrace(buf, buf.getLimit());
            }
        } else {
            while (extra.remaining() > 0) {
                short key = extra.readShort();
                int len = extra.readInt();
                int keyEndPos = extra.getPosition() + len;
                if (key != ExtraInfoKey.FULL_TRC.getValue()) continue;
                this.decodeObFullLinkTrace(extra, keyEndPos);
            }
        }
    }

    private void decodeObFullLinkTrace(Buffer buf, int keyEndPos) throws IOException {
        while (buf.getPosition() < keyEndPos) {
            short type = FullLinkTrace.resolveType(buf);
            int valLen = FullLinkTrace.resolveLength(buf);
            int infoEndPos = buf.getPosition() + valLen;
            if (FullLinkTrace.FullLinkTraceExtraInfoType.FLT_QUERY_INFO.getValue() == type) {
                this.traceInfo.queryInfo.type = FullLinkTrace.FullLinkTraceExtraInfoType.FLT_QUERY_INFO;
                this.traceInfo.queryInfo.deserialize(buf, infoEndPos);
                continue;
            }
            if (FullLinkTrace.FullLinkTraceExtraInfoType.FLT_CONTROL_INFO.getValue() == type) {
                this.traceInfo.controlInfo.type = FullLinkTrace.FullLinkTraceExtraInfoType.FLT_CONTROL_INFO;
                this.traceInfo.controlInfo.deserialize(buf, infoEndPos);
                continue;
            }
            if (FullLinkTrace.FullLinkTraceExtraInfoType.FLT_APP_INFO.getValue() == type) {
                this.traceInfo.appInfo.type = FullLinkTrace.FullLinkTraceExtraInfoType.FLT_APP_INFO;
                this.traceInfo.appInfo.deserialize(buf, infoEndPos);
                continue;
            }
            if (FullLinkTrace.FullLinkTraceExtraInfoType.FLT_SPAN_INFO.getValue() == type) {
                this.traceInfo.spanInfo.type = FullLinkTrace.FullLinkTraceExtraInfoType.FLT_SPAN_INFO;
                this.traceInfo.spanInfo.deserialize(buf, infoEndPos);
                continue;
            }
            buf.skipBytes(valLen);
        }
    }

    public static class ExtraInfo {
        public long extraLength;
        public byte[] extraBytes;
        private boolean useNewExtraInfo;
        public Map<ObObj, ObObj> obobjMap;
        public Map<ExtraInfoKey, byte[]> bytesMap;

        public ExtraInfo(boolean useNewExtraInfo) {
            this.useNewExtraInfo = useNewExtraInfo;
            if (!this.useNewExtraInfo) {
                this.obobjMap = new HashMap<ObObj, ObObj>();
            } else {
                this.bytesMap = new HashMap<ExtraInfoKey, byte[]>();
            }
        }

        public void reset() {
            this.extraLength = 0L;
            if (!this.useNewExtraInfo) {
                this.obobjMap.clear();
            } else {
                this.bytesMap.clear();
            }
            this.extraBytes = null;
        }
    }

    public static class Header {
        public int compressLength;
        public short compressSeqNo;
        public int uncompressLength;
        public short magicNum;
        public short version;
        public long connectionId;
        public int requestId;
        public short obSeqNo;
        public long payloadLength;
        public int flag;
        public short reserved;
        public int headerChecksum;
        private boolean useNewExtraInfo;

        public Header(boolean useNewExtraInfo) {
            this.useNewExtraInfo = useNewExtraInfo;
            this.reset();
        }

        public void reset() {
            this.compressLength = 0;
            this.compressSeqNo = 0;
            this.uncompressLength = 0;
            this.magicNum = (short)8363;
            this.version = (short)20;
            this.connectionId = 0L;
            this.requestId = 0;
            this.obSeqNo = 0;
            this.payloadLength = 0L;
            this.flag = 0;
            if (this.useNewExtraInfo) {
                this.flag |= 8;
            }
            this.reserved = 0;
            this.headerChecksum = 0;
        }

        public String toString() {
            return "compressLength: " + this.compressLength + ", uncompressLength: " + this.uncompressLength + ", magicNum: " + this.magicNum + ", version: " + this.version + ", connectionId: " + this.connectionId + ", requestId: " + this.requestId + ", obSeqNo: " + this.obSeqNo + ", payloadLength: " + this.payloadLength + ", flag: " + this.flag + ", reserved: " + this.reserved + ", headerChecksum: " + this.headerChecksum;
        }
    }

    public static enum ExtraInfoKey {
        OB20_DRIVER_END(1000),
        OB20_PROXY_END(2000),
        TRACE_INFO(2001),
        SESS_INFO(2002),
        FULL_TRC(2003),
        OB20_SVR_END(2004);

        private final short value;

        private ExtraInfoKey(int v) {
            this.value = (short)v;
        }

        public short getValue() {
            return this.value;
        }
    }
}

