/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util.pid;

import com.oceanbase.jdbc.internal.util.pid.JnaPidFactory;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class PidFactory {
    private static Supplier<String> instance;

    public static Supplier<String> getInstance() {
        return instance;
    }

    static {
        try {
            Class<?> processHandle = Class.forName("java.lang.ProcessHandle");
            instance = () -> {
                try {
                    Method currentProcessMethod = processHandle.getMethod("current", new Class[0]);
                    Object currentProcess = currentProcessMethod.invoke(null, new Object[0]);
                    Method pidMethod = processHandle.getMethod("pid", new Class[0]);
                    return String.valueOf(pidMethod.invoke(currentProcess, new Object[0]));
                }
                catch (Throwable throwable) {
                    return null;
                }
            };
        }
        catch (Throwable cle) {
            try {
                instance = JnaPidFactory.getInstance();
            }
            catch (Throwable throwable) {
                instance = () -> null;
            }
        }
    }
}

