/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.outputdevice.helper;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.outputdevice.helper.MinimalFontDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FontFamily<T extends MinimalFontDescription> {
    private final List<T> _fontDescriptions = new ArrayList<T>(4);
    private final String _family;
    private static final int SM_EXACT = 1;
    private static final int SM_LIGHTER_OR_DARKER = 2;
    private static final int SM_DARKER_OR_LIGHTER = 3;

    public FontFamily(String family) {
        this._family = family;
    }

    public String getFamily() {
        return this._family;
    }

    public List<T> getFontDescriptions() {
        return this._fontDescriptions;
    }

    public void addFontDescription(T descr) {
        this._fontDescriptions.add(descr);
        Collections.sort(this._fontDescriptions, Comparator.comparing(MinimalFontDescription::getWeight));
    }

    public T match(int desiredWeight, IdentValue style) {
        if (this._fontDescriptions.isEmpty()) {
            return null;
        }
        if (this._fontDescriptions.size() == 1) {
            return (T)((MinimalFontDescription)this._fontDescriptions.get(0));
        }
        ArrayList<T> candidates = new ArrayList<T>(this._fontDescriptions.size());
        this.getStyleMatches(style, candidates);
        if (candidates.isEmpty() && style == IdentValue.ITALIC) {
            this.getStyleMatches(IdentValue.OBLIQUE, candidates);
        }
        if (candidates.isEmpty() && style == IdentValue.OBLIQUE) {
            this.getStyleMatches(IdentValue.NORMAL, candidates);
        }
        if (candidates.isEmpty()) {
            candidates.addAll(this._fontDescriptions);
        }
        if (candidates.size() == 1) {
            return (T)((MinimalFontDescription)candidates.get(0));
        }
        Object result = this.findByWeight(candidates, desiredWeight, 1);
        if (result != null) {
            return (T)result;
        }
        if (desiredWeight <= 500) {
            return (T)this.findByWeight(candidates, desiredWeight, 2);
        }
        return (T)this.findByWeight(candidates, desiredWeight, 3);
    }

    private void getStyleMatches(IdentValue style, List<T> candidates) {
        for (MinimalFontDescription description : this._fontDescriptions) {
            if (description.getStyle() != style) continue;
            candidates.add(description);
        }
    }

    private T findByWeight(List<T> matches, int desiredWeight, int searchMode) {
        if (searchMode == 1) {
            for (MinimalFontDescription descr : matches) {
                if (descr.getWeight() != desiredWeight) continue;
                return (T)descr;
            }
            return null;
        }
        if (searchMode == 2) {
            int offset = 0;
            MinimalFontDescription descr = null;
            for (offset = 0; offset < matches.size() && (descr = (MinimalFontDescription)matches.get(offset)).getWeight() <= desiredWeight; ++offset) {
            }
            if (offset > 0 && descr.getWeight() > desiredWeight) {
                return (T)((MinimalFontDescription)matches.get(offset - 1));
            }
            return (T)descr;
        }
        if (searchMode == 3) {
            int offset = 0;
            MinimalFontDescription descr = null;
            for (offset = matches.size() - 1; offset >= 0 && (descr = (MinimalFontDescription)matches.get(offset)).getWeight() >= desiredWeight; --offset) {
            }
            if (offset != matches.size() - 1 && descr.getWeight() < desiredWeight) {
                return (T)((MinimalFontDescription)matches.get(offset + 1));
            }
            return (T)descr;
        }
        return null;
    }
}

