/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;

public class OperaPaths {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final Platform currentPlatform = Platform.getCurrent();

    public static String operaPath() {
        String envPath = System.getenv("OPERA_PATH");
        if (OperaPaths.isPathValid(envPath)) {
            return envPath;
        }
        if (envPath != null && envPath.length() > 0) {
            throw new WebDriverException("Path \"" + envPath + "\" in OPERA_PATH does not exist");
        }
        ArrayList<String> paths = new ArrayList<String>();
        switch (currentPlatform) {
            case LINUX: 
            case UNIX: {
                paths.add(OperaPaths.which("opera"));
                paths.add(OperaPaths.which("opera-next"));
                paths.add("/usr/bin/opera");
                paths.add("/usr/bin/opera-next");
                break;
            }
            case MAC: {
                paths.add("/Applications/Opera.app/Contents/MacOS/Opera");
                paths.add("/Applications/Opera Next.app/Contents/MacOS/Opera");
                break;
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                String programFiles = OperaPaths.getWindowsProgramFilesDirectory();
                paths.add(programFiles + "\\Opera\\opera.exe");
                paths.add(programFiles + "\\Opera Next\\opera.exe");
                break;
            }
            default: {
                throw new WebDriverException("Unable to resolve the path to Opera on this platform");
            }
        }
        for (String path : paths) {
            if (!OperaPaths.isPathValid(path)) continue;
            return path;
        }
        return null;
    }

    public static boolean isPathValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    private static String which(String program) {
        if (!currentPlatform.is(Platform.UNIX) && !currentPlatform.is(Platform.LINUX)) {
            throw new WebDriverException("Executing program `which` not possible on this platform");
        }
        CommandLine which = new CommandLine("which", new String[]{program});
        which.execute();
        return which.getStdOut().trim();
    }

    private static String getWindowsProgramFilesDirectory() {
        String programFiles;
        String x86 = System.getenv("ProgramFiles(x86)");
        String string = programFiles = x86 == null ? System.getenv("PROGRAMFILES") : x86;
        if (programFiles == null) {
            programFiles = "\\Program Files";
        }
        return programFiles;
    }
}

