/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner;

import com.opera.core.systems.OperaArguments;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.arguments.OperaCoreArguments;
import com.opera.core.systems.arguments.OperaDesktopArguments;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.File;
import java.util.logging.Level;
import org.openqa.selenium.Platform;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.net.PortProber;

public class OperaRunnerSettings
implements com.opera.core.systems.runner.interfaces.OperaRunnerSettings {
    protected File operaBinary = null;
    protected Integer display = null;
    protected OperaProduct product = OperaProduct.CORE;
    protected String profile = null;
    protected boolean noQuit = false;
    protected String host = "127.0.0.1";
    protected Integer port = 0;
    protected Level loggingLevel = Level.INFO;
    protected com.opera.core.systems.arguments.interfaces.OperaArguments arguments;

    public OperaRunnerSettings() {
        String environmentArguments = System.getenv("OPERA_ARGS");
        if (environmentArguments != null && !environmentArguments.isEmpty()) {
            OperaArguments parsedEnvironmentArguments = OperaArguments.parse(environmentArguments);
            if (this.arguments != null && !this.arguments.getArguments().isEmpty()) {
                this.arguments.merge(parsedEnvironmentArguments);
            } else {
                this.arguments = parsedEnvironmentArguments;
            }
        } else {
            this.arguments = new OperaArguments();
        }
    }

    public File getBinary() {
        return this.operaBinary;
    }

    public void setBinary(String path) {
        File binary;
        if (path != null && !path.isEmpty()) {
            binary = new File(path);
            if (!(binary.exists() && binary.isFile() && binary.canExecute())) {
                throw new OperaRunnerException("No such file or not executable: " + binary);
            }
        } else {
            throw new OperaRunnerException("Invalid file path: " + path);
        }
        this.operaBinary = binary;
    }

    public void setBinary(File binary) {
        if (binary == null) {
            throw new OperaRunnerException("Invalid file: " + binary);
        }
        this.operaBinary = binary;
    }

    public Integer getDisplay() {
        return this.display;
    }

    public void setDisplay(Integer display) throws UnsupportedOperationException {
        if (!Platform.getCurrent().is(Platform.LINUX)) {
            throw new UnsupportedOperationException("Unsupported operating system: " + Platform.getCurrent());
        }
        this.display = display;
    }

    public OperaProduct getProduct() {
        return this.product;
    }

    public void setProduct(OperaProduct product) {
        this.product = product;
    }

    public String getProfile() {
        if (this.profile == null) {
            this.profile = TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera-profile", "").getAbsolutePath();
        }
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean getNoQuit() {
        return this.noQuit;
    }

    public void setNoQuit(boolean noQuit) {
        this.noQuit = noQuit;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        if (this.port == 0) {
            this.port = PortProber.findFreePort();
        } else if (this.port == -1) {
            this.port = (int)OperaIntervals.SERVER_PORT.getValue();
        }
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port == 0 ? Integer.valueOf(PortProber.findFreePort()) : (port == -1 ? Integer.valueOf((int)OperaIntervals.SERVER_PORT.getValue()) : port);
        this.port = port;
    }

    public boolean supportsDebugProxy() {
        return (long)this.port.intValue() != OperaIntervals.SERVER_PORT.getValue();
    }

    public com.opera.core.systems.arguments.interfaces.OperaArguments getArguments() {
        return this.arguments;
    }

    public void setArguments(com.opera.core.systems.arguments.interfaces.OperaArguments arguments) {
        this.arguments = arguments;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level level) {
        this.loggingLevel = level;
    }

    public static OperaRunnerSettings getDefaultSettings() {
        OperaRunnerSettings settings = new OperaRunnerSettings();
        OperaCoreArguments arguments = settings.getProduct().is(OperaProduct.DESKTOP) ? new OperaDesktopArguments() : new OperaCoreArguments();
        settings.setArguments(arguments);
        return settings;
    }
}

