/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.google.protobuf.GeneratedMessage;
import com.opera.core.systems.OperaPaths;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.arguments.OperaArgument;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.runner.launcher.OperaLauncherBinary;
import com.opera.core.systems.runner.launcher.OperaLauncherProtocol;
import com.opera.core.systems.runner.launcher.OperaLauncherProtos;
import com.opera.core.systems.runner.launcher.OperaLauncherRunnerSettings;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.net.PortProber;

public class OperaLauncherRunner
extends OperaRunner
implements com.opera.core.systems.runner.interfaces.OperaRunner {
    private static Logger logger = Logger.getLogger(OperaLauncherRunner.class.getName());
    private OperaLauncherBinary launcherRunner = null;
    private OperaLauncherProtocol launcherProtocol = null;
    private String crashlog = null;

    public OperaLauncherRunner() {
        this(OperaLauncherRunnerSettings.getDefaultSettings());
    }

    public OperaLauncherRunner(OperaLauncherRunnerSettings settings) {
        super(settings);
        Integer launcherPort = PortProber.findFreePort();
        Integer display = settings.getDisplay();
        OperaProduct product = settings.getProduct();
        String profile = settings.getProfile();
        String binary = settings.getBinary() == null ? OperaPaths.operaPath() : settings.getBinary().getAbsolutePath();
        ArrayList<String> launcherArguments = new ArrayList<String>();
        launcherArguments.add("-host");
        launcherArguments.add("127.0.0.1");
        launcherArguments.add("-port");
        launcherArguments.add(launcherPort.toString());
        if (display != null && display > 0) {
            launcherArguments.add("-display");
            launcherArguments.add(":" + display.toString());
        }
        if (settings.getLoggingLevel() != null && settings.getLoggingLevel() != Level.OFF) {
            launcherArguments.add("-console");
            launcherArguments.add("-verbosity");
            launcherArguments.add(settings.getLoggingLevel().toString());
        }
        if (settings.getNoQuit()) {
            launcherArguments.add("-noquit");
        }
        launcherArguments.add("-bin");
        launcherArguments.add(binary);
        for (OperaArgument argument : this.settings.getArguments().getArguments()) {
            launcherArguments.add(this.settings.getArguments().sign() + argument.getArgument());
            if (argument.getValue() == null || argument.getValue().isEmpty()) continue;
            launcherArguments.add(argument.getValue());
        }
        logger.config("launcher arguments: " + ((Object)launcherArguments).toString());
        settings.makeLauncherExecutable();
        this.launcherRunner = new OperaLauncherBinary(settings.getLauncher().getAbsolutePath(), launcherArguments.toArray(new String[launcherArguments.size()]));
        logger.fine("Waiting for launcher connection on port " + launcherPort);
        try {
            ServerSocket listenerServer = new ServerSocket(launcherPort);
            listenerServer.setSoTimeout((int)OperaIntervals.LAUNCHER_TIMEOUT.getValue());
            this.launcherProtocol = new OperaLauncherProtocol(listenerServer.accept());
            logger.fine("Connected with launcher on port " + launcherPort);
            listenerServer.close();
            OperaLauncherProtos.LauncherHandshakeRequest.Builder request = OperaLauncherProtos.LauncherHandshakeRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_HELLO, request.build().toByteArray());
            if (!res.isSuccess()) {
                throw new OperaRunnerException("Did not get launcher handshake: " + res.getResponse().toString());
            }
            logger.finer("Got launcher handshake: " + res.getResponse().toString());
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Timeout waiting for launcher to connect on port " + launcherPort, e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to listen to launcher port " + launcherPort, e);
        }
    }

    public void startOpera() {
        logger.fine("Instructing launcher to start Opera...");
        try {
            byte[] request = OperaLauncherProtos.LauncherStartRequest.newBuilder().build().toByteArray();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_START, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Could not start Opera");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Opera exited immediately; possibly incorrect arguments?  Command: " + this.launcherRunner.getCommand());
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not start Opera", e);
        }
        logger.fine("Opera launched through launcher");
    }

    public void stopOpera() {
        logger.fine("Instructing launcher to stop Opera...");
        try {
            OperaLauncherProtos.LauncherStopRequest.Builder request = OperaLauncherProtos.LauncherStopRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STOP, request.build().toByteArray());
            if (this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Could not stop Opera");
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not stop Opera", e);
        }
        logger.fine("Opera stopped through launcher");
    }

    public boolean isOperaRunning() {
        return this.isOperaRunning(0);
    }

    public boolean isOperaRunning(int processId) {
        try {
            OperaLauncherProtos.LauncherStatusRequest.Builder request = OperaLauncherProtos.LauncherStatusRequest.newBuilder();
            if (processId > 0) {
                request.setProcessid(processId);
            }
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request.build().toByteArray());
            logger.finer("Getting Opera's status from launcher: " + res.getResponse().toString());
            return this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING;
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not get state of Opera", e);
        }
    }

    public boolean hasOperaCrashed() {
        return this.crashlog != null;
    }

    public String getOperaCrashlog() {
        return this.crashlog;
    }

    public void shutdown() {
        logger.fine("Shutting down launcher");
        try {
            try {
                this.launcherProtocol.sendRequestWithoutResponse(OperaLauncherProtocol.MessageType.MSG_SHUTDOWN, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.launcherProtocol.shutdown();
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to shut down launcher", e);
        }
        if (this.launcherRunner != null) {
            this.launcherRunner.shutdown();
            this.launcherRunner = null;
        }
    }

    private OperaLauncherProtos.LauncherStatusResponse.StatusType handleStatusMessage(GeneratedMessage msg) {
        OperaLauncherProtos.LauncherStatusResponse response = (OperaLauncherProtos.LauncherStatusResponse)msg;
        logger.finest("[LAUNCHER] Status: " + response.getStatus().toString());
        if (response.hasExitcode()) {
            logger.finest("[LAUNCHER] Status: exitCode=" + response.getExitcode());
        }
        if (response.hasCrashlog()) {
            logger.finest("[LAUNCHER] Status: crashLog=yes");
        } else {
            logger.finest("[LAUNCHER] Status: crashLog=no");
        }
        if (response.getLogmessagesCount() > 0) {
            for (String message : response.getLogmessagesList()) {
                logger.finest("[LAUNCHER LOG] " + message);
            }
        } else {
            logger.finest("[LAUNCHER LOG] No log...");
        }
        OperaLauncherProtos.LauncherStatusResponse.StatusType status = response.getStatus();
        this.crashlog = status == OperaLauncherProtos.LauncherStatusResponse.StatusType.CRASHED ? (response.hasCrashlog() ? response.getCrashlog().toStringUtf8() : "") : null;
        return status;
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        String resultMd5 = null;
        byte[] resultBytes = null;
        boolean blank = false;
        logger.fine("Instructing launcher to take screenshot");
        try {
            OperaLauncherProtos.LauncherScreenshotRequest.Builder request = OperaLauncherProtos.LauncherScreenshotRequest.newBuilder();
            for (String hash : hashes) {
                request.addKnownMD5S(hash);
            }
            request.setKnownMD5STimeoutMs((int)timeout);
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_SCREENSHOT, request.build().toByteArray());
            OperaLauncherProtos.LauncherScreenshotResponse response = (OperaLauncherProtos.LauncherScreenshotResponse)res.getResponse();
            resultMd5 = response.getMd5();
            resultBytes = response.getImagedata().toByteArray();
            if (response.hasBlank()) {
                blank = response.getBlank();
            }
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher (Socket Timeout)", e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher with exception: " + e, e);
        }
        this.isOperaRunning();
        ScreenShotReply screenshotreply = new ScreenShotReply(resultMd5, resultBytes);
        screenshotreply.setBlank(blank);
        screenshotreply.setCrashed(this.hasOperaCrashed());
        return screenshotreply;
    }

    public static Level toLauncherLoggingLevel(Level level) {
        switch (level.intValue()) {
            case 1000: {
                return Level.SEVERE;
            }
            case 900: {
                return Level.WARNING;
            }
            case 400: 
            case 500: 
            case 700: 
            case 800: {
                return Level.FINE;
            }
            case -2147483648: 
            case 300: {
                return Level.FINEST;
            }
        }
        return Level.OFF;
    }
}

