/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.PrefsCommand;
import com.opera.core.systems.scope.protos.PrefsProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.IPrefs;
import java.util.List;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prefs
extends AbstractService
implements IPrefs {
    public Prefs(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "prefs";
        if (!this.isVersionInRange(version, "2.0", serviceName)) {
            throw new UnsupportedOperationException(serviceName + " version " + version + " is not supported");
        }
        services.setPrefs(this);
    }

    @Override
    public void init() {
    }

    @Override
    public String getPref(String section, String key, PrefsProtos.GetPrefArg.Mode mode) {
        PrefsProtos.GetPrefArg.Builder getPrefBuilder = PrefsProtos.GetPrefArg.newBuilder();
        getPrefBuilder.setSection(section);
        getPrefBuilder.setKey(key);
        getPrefBuilder.setMode(mode);
        UmsProtos.Response response = this.executeCommand(PrefsCommand.GET_PREF, (AbstractMessage.Builder<?>)getPrefBuilder);
        PrefsProtos.PrefValue.Builder prefValueBuilder = PrefsProtos.PrefValue.newBuilder();
        Prefs.buildPayload(response, prefValueBuilder);
        PrefsProtos.PrefValue prefsString = prefValueBuilder.build();
        return prefsString.getValue();
    }

    @Override
    public List<PrefsProtos.Pref> listPrefs(Boolean sort, String section) {
        PrefsProtos.ListPrefsArg.Builder listPrefBuilder = PrefsProtos.ListPrefsArg.newBuilder();
        if (sort != null) {
            listPrefBuilder.setSort(sort);
        }
        if (section != null && !"".equals(section)) {
            listPrefBuilder.setSection(section);
        }
        UmsProtos.Response response = this.executeCommand(PrefsCommand.LIST_PREFS, (AbstractMessage.Builder<?>)listPrefBuilder);
        PrefsProtos.PrefList.Builder prefListBuilder = PrefsProtos.PrefList.newBuilder();
        Prefs.buildPayload(response, prefListBuilder);
        PrefsProtos.PrefList prefList = prefListBuilder.build();
        return prefList.getPrefListList();
    }

    @Override
    public void setPrefs(String section, String key, String value) {
        PrefsProtos.SetPrefArg.Builder setPrefBuilder = PrefsProtos.SetPrefArg.newBuilder();
        setPrefBuilder.setSection(section);
        setPrefBuilder.setKey(key);
        setPrefBuilder.setValue(value);
        UmsProtos.Response response = this.executeCommand(PrefsCommand.SET_PREF, (AbstractMessage.Builder<?>)setPrefBuilder);
        if (response == null) {
            throw new WebDriverException("Internal error while setting a preference");
        }
    }
}

