/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.KggHashGenerator;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.SQLUtil;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public class OracleShardingKeyImpl
implements OracleShardingKey {
    private static final int DEFAULT_CHAR_CHARSET = 873;
    private static final int DEFAULT_NCHAR_CHARSET = 2000;
    private final List<Datum> subKeys;
    private final List<ShardingMetadata.SubKeyMetadata> defaultSubKeyMetadata;
    private boolean isSuperShardingKey = false;
    private final long shardKeyOraHash;
    private final int hashCode;
    private static final NullShardingKeyType NULL_SHARD_KEY_LOW = new NullShardingKeyType(false);
    private static final NullShardingKeyType NULL_SHARD_KEY_HIGH = new NullShardingKeyType(true);

    OracleShardingKeyImpl(OracleShardingKeyBuilderImpl oracleShardingKeyBuilderImpl) {
        ListIterator<Object> listIterator = oracleShardingKeyBuilderImpl.subKeyObjects().listIterator();
        ListIterator<SQLType> listIterator2 = oracleShardingKeyBuilderImpl.subKeyTypes().listIterator();
        int n2 = 0;
        ArrayList<NullShardingKeyType> arrayList = new ArrayList<NullShardingKeyType>();
        ArrayList<ShardingMetadata.SubKeyMetadata> arrayList2 = new ArrayList<ShardingMetadata.SubKeyMetadata>();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object object = listIterator.next();
            SQLType sQLType = listIterator2.next();
            int n3 = -1;
            try {
                Datum datum;
                if (!(object instanceof NullShardingKeyType)) {
                    n3 = OracleShardingKeyImpl.getDefaultSubKeyCharSet(sQLType.getVendorTypeNumber());
                    Class<? extends Datum> clazz = this.getSubKeyDataClass(sQLType.getVendorTypeNumber());
                    datum = JavaToJavaConverter.convert(object, clazz, null, null, CharacterSet.make(n3));
                } else {
                    datum = (NullShardingKeyType)object;
                }
                arrayList.add((NullShardingKeyType)datum);
                arrayList2.add(new ShardingMetadata.SubKeyMetadata(n2, sQLType, n3));
                ++n2;
            }
            catch (SQLException sQLException) {
                throw new IllegalArgumentException("Exception while processing sub key type " + sQLException);
            }
        }
        this.subKeys = Collections.unmodifiableList(arrayList);
        this.defaultSubKeyMetadata = Collections.unmodifiableList(arrayList2);
        int n4 = 1;
        for (Datum datum : this.subKeys) {
            n4 = 31 * n4 + (datum == null ? 0 : datum.bytesHashCode());
        }
        this.hashCode = n4;
        this.shardKeyOraHash = oracleShardingKeyBuilderImpl.getOraHash();
    }

    private List<Datum> getSubKeys() {
        return this.subKeys;
    }

    private List<ShardingMetadata.SubKeyMetadata> getDefaultSubKeyMetadata() {
        return this.defaultSubKeyMetadata;
    }

    public void markSuperShardingKey(boolean bl) {
        this.isSuperShardingKey = bl;
    }

    public boolean isSuperShardingKey() {
        return this.isSuperShardingKey;
    }

    @Override
    public int compareTo(OracleShardingKey oracleShardingKey) {
        if (oracleShardingKey == this) {
            return 0;
        }
        if (!(oracleShardingKey instanceof OracleShardingKeyImpl)) {
            throw new IllegalArgumentException("Sharding Keys being compared are not of the same type");
        }
        OracleShardingKeyImpl oracleShardingKeyImpl = (OracleShardingKeyImpl)oracleShardingKey;
        if (this.shardKeyOraHash != -1L && oracleShardingKeyImpl.shardKeyOraHash != -1L) {
            return this.shardKeyOraHash < oracleShardingKeyImpl.shardKeyOraHash ? -1 : (this.shardKeyOraHash == oracleShardingKeyImpl.shardKeyOraHash ? 0 : 1);
        }
        if (this.subKeys.size() != oracleShardingKeyImpl.getSubKeys().size()) {
            throw new IllegalArgumentException("Sharding Keys being compared are not of the same type");
        }
        ListIterator<Datum> listIterator = this.subKeys.listIterator();
        ListIterator<Datum> listIterator2 = oracleShardingKeyImpl.getSubKeys().listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Datum datum = listIterator.next();
            Datum datum2 = listIterator2.next();
            if (datum instanceof NullShardingKeyType && datum2 instanceof NullShardingKeyType) continue;
            if (datum instanceof NullShardingKeyType) {
                if (((NullShardingKeyType)datum).isShardingKeyHigh()) {
                    return 1;
                }
                return -1;
            }
            if (datum2 instanceof NullShardingKeyType) {
                if (((NullShardingKeyType)datum2).isShardingKeyHigh()) {
                    return -1;
                }
                return 1;
            }
            int n2 = Datum.compareBytes(datum.getBytes(), datum2.getBytes());
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @DisableTrace
    public String toString() {
        try {
            return this.toString(null);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @DisableTrace
    public String toString(Connection connection) throws SQLException {
        if (this.subKeys == null || this.subKeys.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Datum> iterator = this.subKeys.iterator();
        while (iterator.hasNext()) {
            Datum datum = iterator.next();
            if (datum instanceof TIMESTAMPLTZ) {
                if (connection != null) {
                    stringBuffer.append(((TIMESTAMPLTZ)datum).stringValue(connection));
                } else {
                    stringBuffer.append(datum.toString());
                }
            } else {
                stringBuffer.append(datum.stringValue());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    @DisableTrace
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof OracleShardingKeyImpl)) {
            return false;
        }
        OracleShardingKeyImpl oracleShardingKeyImpl = (OracleShardingKeyImpl)object;
        return this.subKeys.equals(oracleShardingKeyImpl.getSubKeys());
    }

    @DisableTrace
    public int hashCode() {
        return this.hashCode;
    }

    public String encodeKeyinB64Format() throws SQLException {
        return new Encoder().encodeKey(this);
    }

    public long shardKeyOraHash(ShardingMetadata shardingMetadata) {
        if (shardingMetadata == null) {
            return -1L;
        }
        if (this.shardKeyOraHash != 0L) {
            return this.shardKeyOraHash;
        }
        List<ShardingMetadata.SubKeyMetadata> list = this.isSuperShardingKey() ? shardingMetadata.getSuperShardingKeyColumns() : shardingMetadata.getShardingKeyColumns();
        return this.subKeys.stream().filter(datum -> datum != null).map(datum -> OracleShardingKeyImpl.encodeInDBCharset(datum, ((ShardingMetadata.SubKeyMetadata)list.get(this.subKeys.indexOf(datum))).getCharSet())).mapToLong(byArray -> KggHashGenerator.kggHash(byArray, ((byte[])byArray).length, 0)).sum();
    }

    public boolean isValid(ShardingMetadata shardingMetadata) {
        List<ShardingMetadata.SubKeyMetadata> list;
        if (shardingMetadata == null) {
            return true;
        }
        List<ShardingMetadata.SubKeyMetadata> list2 = list = this.isSuperShardingKey() ? shardingMetadata.getSuperShardingKeyColumns() : shardingMetadata.getShardingKeyColumns();
        if (list == null) {
            throw new IllegalStateException("Database metadata is not populated");
        }
        if (list.size() != this.subKeys.size()) {
            return false;
        }
        ListIterator<ShardingMetadata.SubKeyMetadata> listIterator = list.listIterator();
        ListIterator<Datum> listIterator2 = this.subKeys.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            ShardingMetadata.SubKeyMetadata subKeyMetadata = listIterator.next();
            Datum datum = listIterator2.next();
            if (this.getSubKeyDataClass(subKeyMetadata.getDataType().getVendorTypeNumber()).equals(datum.getClass())) continue;
            return false;
        }
        return true;
    }

    private static int getDefaultSubKeyCharSet(int n2) {
        if (n2 == 12 || n2 == 1) {
            return 873;
        }
        if (n2 == -9 || n2 == -15) {
            return 2000;
        }
        return -1;
    }

    private Class<? extends Datum> getSubKeyDataClass(int n2) {
        Class clazz = null;
        switch (n2) {
            case 1: 
            case 12: {
                clazz = CHAR.class;
                break;
            }
            case -15: 
            case -9: {
                clazz = CHAR.class;
                break;
            }
            case 2: 
            case 6: {
                clazz = NUMBER.class;
                break;
            }
            case 91: {
                clazz = DATE.class;
                break;
            }
            case 93: {
                clazz = TIMESTAMP.class;
                break;
            }
            case -102: {
                clazz = TIMESTAMPLTZ.class;
                break;
            }
            case -2: {
                clazz = RAW.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Type of sharding key ");
            }
        }
        return clazz;
    }

    public static List<OracleShardingKeyImpl> decodeKeys(InputStream inputStream, ShardingMetadata shardingMetadata, boolean bl, boolean bl2) throws SQLException {
        return new Decoder(shardingMetadata).decodeKey(inputStream, bl, bl2);
    }

    private static byte[] encodeInDBCharset(Datum datum, int n2) {
        Datum datum2;
        try {
            datum2 = datum instanceof CHAR ? new CHAR(datum.toString(), CharacterSet.make(n2)) : datum;
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Invalid sharding key Character set specification in database", sQLException);
        }
        return datum2.getBytes();
    }

    private static byte[] decodeInStandardCharset(byte[] byArray, int n2, SQLType sQLType) {
        byte[] byArray2;
        try {
            switch ((OracleType)sQLType) {
                case VARCHAR2: 
                case CHAR: 
                case NVARCHAR: 
                case NCHAR: {
                    CHAR cHAR = new CHAR(byArray, CharacterSet.make(n2));
                    byArray2 = new CHAR(cHAR.getString(), CharacterSet.make(OracleShardingKeyImpl.getDefaultSubKeyCharSet(sQLType.getVendorTypeNumber()))).getBytes();
                    break;
                }
                default: {
                    byArray2 = byArray;
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Invalid sharding key Character set specification in database", sQLException);
        }
        return byArray2;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static class NullShardingKeyType
    extends Datum {
        final boolean isHighKey;

        private NullShardingKeyType(boolean bl) {
            this.isHighKey = bl;
        }

        boolean isShardingKeyHigh() {
            return this.isHighKey;
        }

        @Override
        public String stringValue() {
            return this.isHighKey ? "MAX" : "MIN";
        }

        @Override
        @DisableTrace
        public boolean equals(Object object) {
            return object instanceof NullShardingKeyType;
        }

        @Override
        public int bytesHashCode() {
            return "NULL".hashCode();
        }

        @Override
        public boolean isConvertibleTo(Class clazz) {
            return false;
        }

        @Override
        public Object toJdbc() throws SQLException {
            return null;
        }

        @Override
        public Object makeJdbcArray(int n2) {
            return null;
        }

        public int hashCode() {
            return this.bytesHashCode();
        }
    }

    static class Decoder {
        private final ShardingMetadata dbMetadata;

        Decoder(ShardingMetadata shardingMetadata) {
            if (shardingMetadata == null) {
                throw new IllegalStateException("sharding key Metadata is null or not initialized");
            }
            this.dbMetadata = shardingMetadata;
        }

        List<OracleShardingKeyImpl> decodeBase64Key(String string2, boolean bl, boolean bl2) throws SQLException {
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            List<byte[]> list = null;
            int n2 = string2.indexOf(",");
            if (n2 < 0) {
                return null;
            }
            String string3 = string2.substring(n2 + 1);
            if (string3.isEmpty()) {
                return null;
            }
            List<String> list2 = Arrays.asList(string3.split(","));
            if (list2.size() <= 0) {
                return null;
            }
            list = list2.stream().filter(string -> string != null).map(string -> Base64.getDecoder().decode(string.getBytes())).collect(Collectors.toList());
            return this.buildShardKeys(list, bl, bl2);
        }

        List<OracleShardingKeyImpl> decodeKey(InputStream inputStream, boolean bl, boolean bl2) throws SQLException {
            ShardingKeyReader shardingKeyReader = new ShardingKeyReader(inputStream);
            List<byte[]> list = shardingKeyReader.hasKeys() ? shardingKeyReader.getKeys() : null;
            return this.buildShardKeys(list, bl, bl2);
        }

        private List<OracleShardingKeyImpl> buildShardKeys(List<byte[]> list, boolean bl, boolean bl2) throws SQLException {
            Object object;
            Object object2;
            Object object3;
            ArrayList<OracleShardingKeyImpl> arrayList = new ArrayList<OracleShardingKeyImpl>();
            List<ShardingMetadata.SubKeyMetadata> list2 = bl ? this.dbMetadata.getSuperShardingKeyColumns() : this.dbMetadata.getShardingKeyColumns();
            ShardingMetadata.ShardingType shardingType = bl ? this.dbMetadata.getSuperShardingType() : this.dbMetadata.getShardingType();
            OracleShardingKeyBuilderImpl oracleShardingKeyBuilderImpl = null;
            if (list == null || list.size() <= 0) {
                throw new IllegalStateException("Null sharding key values in database");
            }
            if (shardingType == ShardingMetadata.ShardingType.HASH) {
                oracleShardingKeyBuilderImpl = new OracleShardingKeyBuilderImpl();
                OracleShardingKeyImpl oracleShardingKeyImpl = null;
                byte[] byArray2 = list.get(0);
                oracleShardingKeyImpl = byArray2.length > 0 ? oracleShardingKeyBuilderImpl.subkey(list.get(0), OracleType.NUMBER).oraHash(NUMBER.toLong(list.get(0))).build() : oracleShardingKeyBuilderImpl.subkey(bl2 ? NULL_SHARD_KEY_HIGH : NULL_SHARD_KEY_LOW, OracleType.ANYDATA).build();
                if (oracleShardingKeyImpl != null) {
                    oracleShardingKeyImpl.markSuperShardingKey(bl);
                    arrayList.add(oracleShardingKeyImpl);
                }
                return arrayList;
            }
            ListIterator<ShardingMetadata.SubKeyMetadata> listIterator = list2.listIterator();
            oracleShardingKeyBuilderImpl = new OracleShardingKeyBuilderImpl();
            if (shardingType == ShardingMetadata.ShardingType.RANGE) {
                if (list.size() != list2.size()) {
                    throw new IllegalStateException("Mismatch in Sharding database metadata and sharding key values");
                }
                object3 = list.stream().map(byArray -> {
                    int n2 = list.indexOf(byArray);
                    ShardingMetadata.SubKeyMetadata subKeyMetadata = (ShardingMetadata.SubKeyMetadata)list2.get(n2);
                    return OracleShardingKeyImpl.decodeInStandardCharset(byArray, subKeyMetadata.getCharSet(), subKeyMetadata.getDataType());
                }).collect(Collectors.toList());
                object2 = object3.listIterator();
                while (listIterator.hasNext() && object2.hasNext()) {
                    object = (byte[])object2.next();
                    ShardingMetadata.SubKeyMetadata subKeyMetadata = listIterator.next();
                    if (((Object)object).length == 0) {
                        oracleShardingKeyBuilderImpl.subkey(bl2 ? NULL_SHARD_KEY_HIGH : NULL_SHARD_KEY_LOW, OracleType.ANYDATA);
                        continue;
                    }
                    oracleShardingKeyBuilderImpl.subkey(object, subKeyMetadata.getDataType());
                }
                object = oracleShardingKeyBuilderImpl.build();
                ((OracleShardingKeyImpl)object).markSuperShardingKey(bl);
                arrayList.add((OracleShardingKeyImpl)object);
            }
            if (shardingType == ShardingMetadata.ShardingType.LIST) {
                object3 = list.listIterator();
                while (object3.hasNext()) {
                    while (listIterator.hasNext()) {
                        object2 = listIterator.next();
                        object = OracleShardingKeyImpl.decodeInStandardCharset((byte[])object3.next(), ((ShardingMetadata.SubKeyMetadata)object2).getCharSet(), ((ShardingMetadata.SubKeyMetadata)object2).getDataType());
                        oracleShardingKeyBuilderImpl.subkey(object, ((ShardingMetadata.SubKeyMetadata)object2).getDataType());
                    }
                    object2 = oracleShardingKeyBuilderImpl.build();
                    ((OracleShardingKeyImpl)object2).markSuperShardingKey(bl);
                    arrayList.add((OracleShardingKeyImpl)object2);
                    oracleShardingKeyBuilderImpl = new OracleShardingKeyBuilderImpl();
                    listIterator = list2.listIterator();
                }
            }
            return arrayList;
        }

        private class ShardingKeyReader {
            private final InputStream stream;
            private boolean hasKeys = false;
            private static final int KDKLBLEN = 128;
            private static final int KDKLNULL = 255;

            public ShardingKeyReader(InputStream inputStream) {
                this.stream = inputStream;
                if (inputStream != null) {
                    this.hasKeys = true;
                }
            }

            public boolean hasKeys() {
                return this.hasKeys;
            }

            public List<byte[]> getKeys() {
                if (!this.hasKeys) {
                    return null;
                }
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                while (this.hasNext()) {
                    arrayList.add(this.next());
                }
                this.hasKeys = false;
                return arrayList;
            }

            private boolean hasNext() {
                try {
                    return this.stream.available() > 0;
                }
                catch (IOException iOException) {
                    this.hasKeys = false;
                    return false;
                }
            }

            private byte[] next() {
                try {
                    int n2 = this.stream.read();
                    if (n2 == 255) {
                        n2 = 0;
                    } else if (n2 >= 128) {
                        n2 = ((n2 & 0x8F) << 8) + this.stream.read();
                    }
                    byte[] byArray = new byte[n2];
                    this.stream.read(byArray);
                    return byArray;
                }
                catch (IOException iOException) {
                    this.hasKeys = false;
                    return null;
                }
            }
        }
    }

    static class Encoder {
        private static final int TNS_HEADER_VERSION = 1;
        private final String headerVersionTypeStr;

        Encoder() {
            int n2 = 0;
            this.headerVersionTypeStr = "1 " + n2;
        }

        String encodeKey(OracleShardingKey oracleShardingKey) throws SQLException {
            String string3 = "";
            if (oracleShardingKey == null) {
                return "";
            }
            OracleShardingKeyImpl oracleShardingKeyImpl = null;
            if (!(oracleShardingKey instanceof OracleShardingKeyImpl)) {
                throw new IllegalArgumentException("Invalid type of sharding key for Encoding");
            }
            oracleShardingKeyImpl = (OracleShardingKeyImpl)oracleShardingKey;
            if (oracleShardingKeyImpl.getSubKeys().size() == 0) {
                return "";
            }
            String string4 = null;
            List list = oracleShardingKeyImpl.getSubKeys();
            string4 = oracleShardingKeyImpl.getDefaultSubKeyMetadata().stream().filter(subKeyMetadata -> subKeyMetadata != null).map(subKeyMetadata -> {
                try {
                    return SQLUtil.getInternalType(subKeyMetadata.getDataType().getVendorTypeNumber()) + "";
                }
                catch (SQLException sQLException) {
                    throw new IllegalArgumentException("Invalid sharding key data type");
                }
            }).reduce(this.headerVersionTypeStr, (string, string2) -> {
                string = string + " " + string2;
                return string;
            });
            string3 = list.stream().filter(datum -> datum != null).map(datum -> Base64.getEncoder().encodeToString(datum.getBytes())).reduce(string4, (string, string2) -> {
                string = string + "," + string2;
                return string;
            });
            return string3;
        }
    }
}

