/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.util.Arrays;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.JsonpParserWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OracleOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.sql.CHAR;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

public class OsonParserImpl
extends OracleOsonValueFactory
implements OracleJsonParser {
    private static int INITIAL_DEPTH_CAPACITY = 4;
    private final OsonContext ctx;
    private State state;
    private int depth;
    private OracleJsonStructure[] depthStack;
    private int[] currentChild;
    private OsonAbstractObject[] objectCache;
    private OsonAbstractArray[] arrayCache;
    private OracleJsonDecimalImpl numberCache;
    private StringPointer stringPointer = new StringPointer();
    private OracleJsonValue currentPrimitive;
    private Closeable closeable;
    OracleJsonParser.Event event;

    public OsonParserImpl(OsonContext osonContext) {
        this.ctx = osonContext;
        this.depthStack = new OracleJsonStructure[INITIAL_DEPTH_CAPACITY];
        this.currentChild = new int[INITIAL_DEPTH_CAPACITY];
        this.objectCache = new OsonAbstractObject[INITIAL_DEPTH_CAPACITY];
        this.arrayCache = new OsonAbstractArray[INITIAL_DEPTH_CAPACITY];
        this.init();
    }

    private void init() {
        this.state = State.START;
        this.depth = -1;
        this.event = null;
    }

    @Override
    public boolean hasNext() {
        return this.state != State.FINISHED;
    }

    @Override
    public OracleJsonParser.Event next() {
        switch (this.state) {
            case START: {
                int n2 = this.ctx.getHeader().getTreeSegmentOffset();
                this.pushDepth();
                OracleJsonValue oracleJsonValue = (OracleJsonValue)OsonStructureImpl.getValueInternal(n2, this, this.ctx);
                if (oracleJsonValue.getOracleJsonType() != OracleJsonValue.OracleJsonType.ARRAY && oracleJsonValue.getOracleJsonType() != OracleJsonValue.OracleJsonType.OBJECT) {
                    this.state = State.FINISHED;
                    this.currentPrimitive = oracleJsonValue;
                    this.event = this.OracleJsonTypeToEvent(oracleJsonValue);
                    return this.event;
                }
                this.setCurrent((OracleJsonStructure)oracleJsonValue);
                this.state = State.NEXT_VALUE;
                if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
                    this.event = OracleJsonParser.Event.START_ARRAY;
                    return this.event;
                }
                this.event = OracleJsonParser.Event.START_OBJECT;
                return this.event;
            }
            case NEXT_VALUE: {
                this.event = this.nextValue();
                return this.event;
            }
            case AFTER_KEY: {
                this.state = State.NEXT_VALUE;
                this.event = this.nextChild();
                return this.event;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public String getString() {
        if (this.state == State.AFTER_KEY) {
            return ((OsonAbstractObject)((Object)this.depthStack[this.depth])).getFieldName(this.currentChild[this.depth]);
        }
        if (this.currentPrimitive != null) {
            switch (this.currentPrimitive.getOracleJsonType()) {
                case BINARY: {
                    return ((OracleJsonBinary)this.currentPrimitive).getString();
                }
                case DATE: {
                    return ((OracleJsonDate)this.currentPrimitive).getString();
                }
                case DECIMAL: 
                case FLOAT: 
                case DOUBLE: {
                    return ((OracleJsonNumberImpl)((Object)this.currentPrimitive)).getString();
                }
                case INTERVALDS: {
                    return ((OracleJsonIntervalDS)this.currentPrimitive).getString();
                }
                case INTERVALYM: {
                    return ((OracleJsonIntervalYM)this.currentPrimitive).getString();
                }
                case STRING: {
                    return ((OracleJsonString)this.currentPrimitive).getString();
                }
                case TIMESTAMP: {
                    return ((OracleJsonTimestamp)this.currentPrimitive).getString();
                }
            }
            throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
    }

    @Override
    public boolean isIntegralNumber() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).isIntegral();
    }

    @Override
    public int getInt() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).intValue();
    }

    @Override
    public long getLong() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).bigDecimalValue();
    }

    @Override
    public BigInteger getBigInteger() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).bigIntegerValue();
    }

    @Override
    public double getDouble() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).doubleValue();
    }

    @Override
    public float getFloat() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).floatValue();
    }

    @Override
    public Instant getInstant() {
        if (this.currentPrimitive == null) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMP.toString());
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return ((OracleJsonTimestampImpl)this.currentPrimitive).getInstant();
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDateImpl)this.currentPrimitive).getInstant();
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMP.toString());
    }

    @Override
    public byte[] getBytes() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.BINARY);
        return ((OracleJsonBinaryImpl)this.currentPrimitive).getBytes();
    }

    @Override
    public Period getPeriod() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.INTERVALYM);
        return ((OracleJsonIntervalYMImpl)this.currentPrimitive).getPeriod();
    }

    @Override
    public Duration getDuration() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.INTERVALDS);
        return ((OracleJsonIntervalDSImpl)this.currentPrimitive).getDuration();
    }

    @Override
    public OracleJsonObject getObject() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.OBJECT);
        OsonAbstractObject osonAbstractObject = (OsonAbstractObject)((Object)this.getCurrent());
        this.objectCache[this.depth] = null;
        this.pop();
        return (OracleJsonObject)((Object)osonAbstractObject);
    }

    @Override
    public OracleJsonValue getValue() {
        OracleOsonValueFactory oracleOsonValueFactory = OracleOsonValueFactory.INSTANCE;
        if (this.event == null || this.event == OracleJsonParser.Event.END_ARRAY || this.event == OracleJsonParser.Event.END_OBJECT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE_VALUE.create(this.ctx.getExceptionFactory(), new Object[0]);
        }
        if (this.event == OracleJsonParser.Event.KEY_NAME) {
            return new OracleJsonStringImpl(this.getString());
        }
        if (this.event == OracleJsonParser.Event.VALUE_NULL) {
            return OracleJsonValue.NULL;
        }
        if (this.event == OracleJsonParser.Event.VALUE_FALSE) {
            return OracleJsonValue.FALSE;
        }
        if (this.event == OracleJsonParser.Event.VALUE_TRUE) {
            return OracleJsonValue.TRUE;
        }
        OracleJsonValue oracleJsonValue = this.currentPrimitive == null ? this.getCurrent() : this.currentPrimitive;
        switch (oracleJsonValue.getOracleJsonType()) {
            case BINARY: {
                OracleJsonBinaryImpl oracleJsonBinaryImpl = (OracleJsonBinaryImpl)oracleJsonValue;
                return new OracleJsonBinaryImpl(oracleJsonBinaryImpl.getBytes(), oracleJsonBinaryImpl.isId());
            }
            case DOUBLE: {
                OracleJsonDoubleImpl oracleJsonDoubleImpl = (OracleJsonDoubleImpl)oracleJsonValue;
                return new OracleJsonDoubleImpl(oracleJsonDoubleImpl.doubleValue());
            }
            case FLOAT: {
                OracleJsonFloatImpl oracleJsonFloatImpl = (OracleJsonFloatImpl)oracleJsonValue;
                return new OracleJsonFloatImpl(oracleJsonFloatImpl.floatValue());
            }
            case DECIMAL: {
                if (oracleJsonValue instanceof OracleJsonStringNumberImpl) {
                    OracleJsonStringNumberImpl oracleJsonStringNumberImpl = (OracleJsonStringNumberImpl)oracleJsonValue;
                    return new OracleJsonStringNumberImpl(oracleJsonStringNumberImpl.getString());
                }
                OracleJsonDecimalImpl oracleJsonDecimalImpl = (OracleJsonDecimalImpl)oracleJsonValue;
                return new OracleJsonDecimalImpl(oracleJsonDecimalImpl.raw(), oracleJsonDecimalImpl.getTargetType());
            }
            case STRING: {
                return new OracleJsonStringImpl(((OracleJsonString)oracleJsonValue).getString());
            }
            case TIMESTAMP: {
                OracleJsonTimestampImpl oracleJsonTimestampImpl = (OracleJsonTimestampImpl)oracleJsonValue;
                return oracleOsonValueFactory.createTimestamp(oracleJsonTimestampImpl.raw());
            }
            case DATE: {
                OracleJsonDateImpl oracleJsonDateImpl = (OracleJsonDateImpl)oracleJsonValue;
                return oracleOsonValueFactory.createDate(oracleJsonDateImpl.raw());
            }
            case INTERVALDS: {
                OracleJsonIntervalDSImpl oracleJsonIntervalDSImpl = (OracleJsonIntervalDSImpl)oracleJsonValue;
                return oracleOsonValueFactory.createIntervalDS(oracleJsonIntervalDSImpl.raw());
            }
            case INTERVALYM: {
                OracleJsonIntervalYMImpl oracleJsonIntervalYMImpl = (OracleJsonIntervalYMImpl)oracleJsonValue;
                return oracleOsonValueFactory.createIntervalYM(oracleJsonIntervalYMImpl.raw());
            }
            case ARRAY: {
                return this.getArray();
            }
        }
        return this.getObject();
    }

    @Override
    public OracleJsonArray getArray() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.ARRAY);
        OsonAbstractArray osonAbstractArray = (OsonAbstractArray)((Object)this.getCurrent());
        this.arrayCache[this.depth] = null;
        this.pop();
        return (OracleJsonArray)((Object)osonAbstractArray);
    }

    @Override
    public void skipArray() {
        if (this.depth < 0) {
            return;
        }
        if (this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
            this.pop();
            this.currentPrimitive = null;
        }
    }

    @Override
    public void skipObject() {
        if (this.depth < 0) {
            return;
        }
        if (this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.pop();
            this.currentPrimitive = null;
        }
    }

    @Override
    public void close() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                throw OracleJsonExceptions.IO.create(this.ctx.getExceptionFactory(), iOException, new Object[0]);
            }
            this.closeable = null;
        }
        this.depth = -1;
        this.state = State.FINISHED;
        this.event = null;
    }

    public void setCloseable(Closeable closeable) {
        this.closeable = closeable;
    }

    @Override
    public OsonAbstractArray createArray(OsonContext osonContext, int n2) {
        if (this.arrayCache[this.depth] == null) {
            this.arrayCache[this.depth] = osonContext.getFactory().createArray(osonContext, n2);
        } else {
            this.arrayCache[this.depth].init(n2);
        }
        return this.arrayCache[this.depth];
    }

    @Override
    public OsonAbstractObject createObject(OsonContext osonContext, int n2) {
        if (this.objectCache[this.depth] == null) {
            this.objectCache[this.depth] = osonContext.getFactory().createObject(osonContext, n2);
        } else {
            this.objectCache[this.depth].init(n2);
        }
        return this.objectCache[this.depth];
    }

    @Override
    public Object createString(OsonContext osonContext, int n2, int n3) {
        this.stringPointer.reset(n2, n3);
        return this.stringPointer;
    }

    @Override
    public OracleJsonDecimalImpl createNumber(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        if (this.numberCache == null) {
            this.numberCache = super.createNumber(byArray, targetType);
        } else {
            this.numberCache.reset(byArray, targetType);
        }
        return this.numberCache;
    }

    public boolean toEntry(String string) {
        if (this.event != OracleJsonParser.Event.START_OBJECT) {
            throw new IllegalStateException();
        }
        OsonObjectImpl osonObjectImpl = (OsonObjectImpl)this.getCurrent();
        int n2 = osonObjectImpl.getChildPosition(string);
        if (n2 == -1) {
            return false;
        }
        this.currentChild[this.depth] = n2;
        this.event = OracleJsonParser.Event.KEY_NAME;
        this.state = State.AFTER_KEY;
        return true;
    }

    public void reset() {
        this.init();
    }

    private void setCurrent(OracleJsonStructure oracleJsonStructure) {
        this.currentChild[this.depth] = 0;
        this.depthStack[this.depth] = oracleJsonStructure;
        this.currentPrimitive = null;
    }

    private OracleJsonStructure getCurrent() {
        return this.depthStack[this.depth];
    }

    private void pop() {
        --this.depth;
        if (this.depth < 0) {
            this.state = State.FINISHED;
        }
    }

    private OracleJsonParser.Event nextChild() {
        int n2 = this.currentChild[this.depth];
        int n3 = this.depth;
        this.currentChild[n3] = this.currentChild[n3] + 1;
        int n4 = ((OsonStructureImpl)((Object)this.depthStack[this.depth])).getChildOffset(n2);
        this.pushDepth();
        OracleJsonValue oracleJsonValue = (OracleJsonValue)OsonStructureImpl.getValueInternal(n4, this, this.ctx);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.setCurrent((OracleJsonStructure)oracleJsonValue);
            return OracleJsonParser.Event.START_OBJECT;
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
            this.setCurrent((OracleJsonStructure)oracleJsonValue);
            return OracleJsonParser.Event.START_ARRAY;
        }
        this.currentPrimitive = oracleJsonValue;
        --this.depth;
        return this.OracleJsonTypeToEvent(oracleJsonValue);
    }

    private OracleJsonParser.Event OracleJsonTypeToEvent(OracleJsonValue oracleJsonValue) {
        switch (oracleJsonValue.getOracleJsonType()) {
            case FALSE: {
                return OracleJsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return OracleJsonParser.Event.VALUE_NULL;
            }
            case DECIMAL: {
                return OracleJsonParser.Event.VALUE_DECIMAL;
            }
            case STRING: {
                return OracleJsonParser.Event.VALUE_STRING;
            }
            case TRUE: {
                return OracleJsonParser.Event.VALUE_TRUE;
            }
            case BINARY: {
                return OracleJsonParser.Event.VALUE_BINARY;
            }
            case DOUBLE: {
                return OracleJsonParser.Event.VALUE_DOUBLE;
            }
            case FLOAT: {
                return OracleJsonParser.Event.VALUE_FLOAT;
            }
            case INTERVALDS: {
                return OracleJsonParser.Event.VALUE_INTERVALDS;
            }
            case INTERVALYM: {
                return OracleJsonParser.Event.VALUE_INTERVALYM;
            }
            case DATE: {
                return OracleJsonParser.Event.VALUE_DATE;
            }
            case TIMESTAMP: {
                return OracleJsonParser.Event.VALUE_TIMESTAMP;
            }
        }
        throw new IllegalStateException(oracleJsonValue.toString());
    }

    private void pushDepth() {
        ++this.depth;
        if (this.depth >= this.depthStack.length) {
            this.expand();
        }
    }

    private void expand() {
        this.depthStack = Arrays.copyOf(this.depthStack, this.depthStack.length * 2);
        this.currentChild = Arrays.copyOf(this.currentChild, this.depthStack.length);
        this.objectCache = Arrays.copyOf(this.objectCache, this.depthStack.length);
        this.arrayCache = Arrays.copyOf(this.arrayCache, this.depthStack.length);
    }

    private OracleJsonParser.Event nextValue() {
        if (this.currentChild[this.depth] >= ((OsonStructureImpl)((Object)this.depthStack[this.depth])).size()) {
            if (this.depthStack[this.depth].getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
                this.pop();
                return OracleJsonParser.Event.END_OBJECT;
            }
            this.pop();
            return OracleJsonParser.Event.END_ARRAY;
        }
        if (this.depthStack[this.depth].getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.state = State.AFTER_KEY;
            return OracleJsonParser.Event.KEY_NAME;
        }
        return this.nextChild();
    }

    private void assertNumeric() {
        OracleJsonValue oracleJsonValue = this.currentPrimitive == null ? this.getCurrent() : this.currentPrimitive;
        OracleJsonValue.OracleJsonType oracleJsonType = oracleJsonValue.getOracleJsonType();
        if (oracleJsonType != OracleJsonValue.OracleJsonType.DECIMAL && oracleJsonType != OracleJsonValue.OracleJsonType.DOUBLE && oracleJsonType != OracleJsonValue.OracleJsonType.FLOAT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
        }
    }

    private void assertJsonType(OracleJsonValue.OracleJsonType oracleJsonType) {
        if (this.depth < 0) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
        }
        switch (oracleJsonType) {
            case ARRAY: {
                if (this.currentPrimitive == null && this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
            }
            case OBJECT: {
                if (this.currentPrimitive == null && this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
            }
            default: {
                if (this.currentPrimitive != null && this.currentPrimitive.getOracleJsonType() == oracleJsonType) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), oracleJsonType.toString());
            }
        }
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        try {
            return clazz.cast(new JsonpParserWrapper(this));
        }
        catch (ClassCastException classCastException) {
            throw OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, classCastException, clazz.getName());
        }
    }

    public long getStreamOffset() {
        if (this.state == State.START) {
            return 0L;
        }
        return -1L;
    }

    public OsonContext getContext() {
        return this.ctx;
    }

    public int getCurrentStringPos() {
        return this.stringPointer.getPos();
    }

    public int getCurrentStringLen() {
        return this.stringPointer.getLen();
    }

    private static enum State {
        START,
        NEXT_VALUE,
        AFTER_KEY,
        FINISHED;

    }

    private class StringPointer
    implements OracleJsonString {
        int pos;
        int len;

        private StringPointer() {
        }

        @Override
        public OracleJsonValue.OracleJsonType getOracleJsonType() {
            return OracleJsonValue.OracleJsonType.STRING;
        }

        @Override
        public <T> T wrap(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString() {
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.position(this.pos);
            return ((OsonParserImpl)OsonParserImpl.this).ctx.b.readString(this.len);
        }

        @Override
        public CharSequence getChars() {
            return this.getString();
        }

        @Override
        public CHAR getCHAR() {
            throw new UnsupportedOperationException();
        }

        public void reset(int n2, int n3) {
            this.pos = n2;
            this.len = n3;
        }

        public int getLen() {
            return this.len;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

