/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.beans.PropertyChangeEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogManager;
import oracle.jdbc.clio.annotations.Sensitive;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Diagnostic;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.diagnostics.TraceAttributes;
import oracle.jdbc.driver.DatabaseError;

public abstract class AbstractDiagnosable
implements Diagnosable {
    protected Diagnostic diagnostic;
    private int suspendCount = 0;
    public static final Predicate<String> IS_VALID_BUFFER_SIZE = size -> {
        Integer sz;
        try {
            sz = Integer.parseInt(size);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return sz > 0;
    };
    protected static final Predicate<String> IS_VALID_BOOLEAN_STRING = value -> "true".equalsIgnoreCase((String)value) || "false".equalsIgnoreCase((String)value);
    protected static final Predicate<String> IS_VALID_LOGGER_NAME = value -> value != null && !value.isEmpty();
    private static volatile boolean isGlobalDebugEnabled = Boolean.parseBoolean(AbstractDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.enableLogging", "false", IS_VALID_BOOLEAN_STRING));
    private static volatile boolean isWriteLogsToDiagnoseFirstFailure = Boolean.parseBoolean(AbstractDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.writeLogsToDiagnoseFirstFailure", "false", IS_VALID_BOOLEAN_STRING));
    private static AtomicBoolean isMetricsEnabled = new AtomicBoolean(Boolean.parseBoolean(AbstractDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.enableMetrics", "false", IS_VALID_BOOLEAN_STRING)));

    protected abstract void setDebugEnabled(boolean var1);

    protected abstract void setDiagnoseFirstFailureEnabled(boolean var1);

    protected abstract boolean isSensitivePermitted();

    protected abstract String getDiagnosticLoggerName();

    protected abstract TraceAttributes getTraceAttributes();

    private boolean isDiagnoseFirstFailureActive() {
        return this.isDiagnoseFirstFailureEnabled() && this.suspendCount == 0;
    }

    private boolean isDebugActive() {
        return this.isDebugEnabled() && this.suspendCount == 0;
    }

    protected void setSensitiveEnabled(boolean enabled) {
        if (enabled && !this.isSensitivePermitted()) {
            throw new IllegalStateException(DatabaseError.formatSqlException(null, 1725, null, null, "oracle.jdbc.diagnostic.permitSensitiveDiagnostics").getMessage());
        }
        this.diagnostic.enableSensitive(enabled);
    }

    public void enableDiagnoseFirstFailureDump(boolean enableDump) {
        this.diagnostic.enableDiagnoseFirstFailureDump(enableDump);
    }

    protected static String getSystemProperty(String key, String defaultValue, Predicate isValid) {
        if (key == null) {
            return defaultValue;
        }
        String value = AccessController.doPrivileged(() -> System.getProperty(key, defaultValue));
        return isValid.test(value) ? value : defaultValue;
    }

    protected void abstractPropertyChange(PropertyChangeEvent event) {
        Object newValue = event.getNewValue();
        switch (event.getPropertyName()) {
            case "Event-Enable-DiagnoseFirstFailure-By-Logger-Name": {
                if (!((String)newValue).equalsIgnoreCase(this.getDiagnosticLoggerName())) break;
                this.setDiagnoseFirstFailureEnabled(true);
                break;
            }
            case "Event-Disable-DiagnoseFirstFailure-By-Logger-Name": {
                if (!((String)newValue).equalsIgnoreCase(this.getDiagnosticLoggerName())) break;
                this.setDiagnoseFirstFailureEnabled(false);
                break;
            }
            case "Event-Enable-DiagnoseFirstFailure": {
                this.setDiagnoseFirstFailureEnabled(true);
                break;
            }
            case "Event-Disable-DiagnoseFirstFailure": {
                this.setDiagnoseFirstFailureEnabled(false);
                break;
            }
            case "Event-Enable-Logging-By-Logger-Name": {
                if (!((String)newValue).equalsIgnoreCase(this.getDiagnosticLoggerName())) break;
                this.setDebugEnabled(true);
                break;
            }
            case "Event-Disable-Logging-By-Logger-Name": {
                if (!((String)newValue).equalsIgnoreCase(this.getDiagnosticLoggerName())) break;
                this.setDebugEnabled(false);
                break;
            }
            case "Event-Enable-Logging": {
                this.setDebugEnabled(true);
                break;
            }
            case "Event-Disable-Logging": {
                this.setDebugEnabled(false);
                break;
            }
            case "Event-Enable-Sensitive-Diagnostics-By-Logger-Name": {
                if (!((String)newValue).equalsIgnoreCase(this.getDiagnosticLoggerName())) break;
                this.setSensitiveEnabled(true);
                break;
            }
            case "Event-Disable-Sensitive-Diagnostics-By-Logger-Name": {
                if (!((String)newValue).equalsIgnoreCase(this.getDiagnosticLoggerName())) break;
                this.setSensitiveEnabled(false);
                break;
            }
            case "Event-Enable-Sensitive-Diagnostics": {
                this.setSensitiveEnabled(true);
                break;
            }
            case "Event-Disable-Sensitive-Diagnostics": {
                this.setSensitiveEnabled(false);
                break;
            }
            case "Event-Update-Diagnostic-Level-By-Logger-Name": {
                if (!((Object[])newValue)[0].equals(this.getDiagnosticLoggerName())) break;
                this.diagnostic.setLoggingLevel((String)((Object[])newValue)[1]);
                break;
            }
            case "Event-Update-Diagnostic-Level": {
                this.diagnostic.setLoggingLevel((String)newValue);
                break;
            }
            case "Event-Update-DiagnoseFirstFailure-Size-By-Logger-Name": {
                if (!((Object[])newValue)[0].equals(this.getDiagnosticLoggerName()) || !IS_VALID_BUFFER_SIZE.test(String.valueOf(((Object[])newValue)[1]))) break;
                this.diagnostic.setDiagnoseFirstFailureBufferSize((Integer)((Object[])newValue)[1]);
                break;
            }
            case "Event-Update-DiagnoseFirstFailure-Size": {
                if (!IS_VALID_BUFFER_SIZE.test(String.valueOf(newValue))) break;
                this.diagnostic.setDiagnoseFirstFailureBufferSize((Integer)newValue);
            }
        }
    }

    @Override
    public boolean isSensitiveEnabled() {
        return this.diagnostic != null && this.diagnostic.isSensitiveEnabled();
    }

    protected static void onConfigFileChange(String loggingConfigFileName) {
        AccessController.doPrivileged(() -> {
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream(loggingConfigFileName));
            }
            catch (IOException | SecurityException exception) {
                throw new RuntimeException(exception);
            }
            return null;
        });
    }

    public static void enableGlobalDebug(boolean enabled) {
        isGlobalDebugEnabled = enabled;
    }

    public static boolean isGlobalDebugEnabled() {
        return isGlobalDebugEnabled;
    }

    public static void enableWriteLogsToDiagnoseFirstFailure(boolean enabled) {
        isWriteLogsToDiagnoseFirstFailure = enabled;
    }

    public static boolean isWriteLogsToDiagnoseFirstFailureEnabled() {
        return isWriteLogsToDiagnoseFirstFailure;
    }

    public static void enableMetrics(boolean isEnabled) {
        isMetricsEnabled.set(isEnabled);
    }

    public static boolean isMetricsEnabled() {
        return isMetricsEnabled.get();
    }

    @Override
    public final <T extends Throwable> T trace(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, args);
        } else if (this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, args);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, args);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, args);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, new Object[0]);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, new Object[0]);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5, arg6);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5, arg6);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debug(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        if (this.isDebugActive()) {
            this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        } else if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T tracep(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Supplier<Object[]> argsSupplier) {
        if (this.isDebugActive() && this.isLoggable(level)) {
            return this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, argsSupplier.get());
        }
        if (this.isDiagnoseFirstFailureActive()) {
            return this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, argsSupplier.get());
        }
        return thrown;
    }

    @Override
    public final <T extends Throwable> T debugp(Level level, SecurityLabel label, String className, String methodName, String publicMessage, String privateMessage, T thrown, Supplier<Object[]> argsSupplier) {
        if (this.isDebugActive() && this.isLoggable(level)) {
            return this.diagnostic.debug(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, argsSupplier.get());
        }
        if (isWriteLogsToDiagnoseFirstFailure && this.isDiagnoseFirstFailureActive()) {
            return this.diagnostic.trace(level, label, className, methodName, this.getTraceAttributes(), thrown, publicMessage, privateMessage, argsSupplier.get());
        }
        return thrown;
    }

    @Override
    public Object secure(@Sensitive Object value) {
        if (this.diagnostic.isSensitiveEnabled() && this.isSensitivePermitted()) {
            return value;
        }
        return "*****";
    }

    @Override
    public void suspendLogging() {
        ++this.suspendCount;
    }

    @Override
    public void resumeLogging() {
        --this.suspendCount;
        assert (this.suspendCount >= 0);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.diagnostic.isLoggable(level);
    }

    @Override
    public void onClose() {
    }

    @Override
    public void begin(Metrics.ConnectionEvent event) {
    }

    @Override
    public void begin(Metrics.ConnectionEvent event, int retryCount) {
    }

    @Override
    public void end(Metrics.ConnectionEvent event) {
    }

    @Override
    public void end(Metrics.ConnectionEvent event, int retryCount) {
    }
}

