/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.StandardMBean;
import oracle.jdbc.diagnostics.AbstractDiagnosable;
import oracle.jdbc.diagnostics.Diagnostic;
import oracle.jdbc.diagnostics.DiagnosticsMXBean;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.driver.DatabaseError;

public class OracleDiagnosticsMXBean
extends StandardMBean
implements DiagnosticsMXBean {
    private static final OracleDiagnosticsMXBean INSTANCE = new OracleDiagnosticsMXBean();
    public static final String EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE_BY_CONN_ID_PREFIX = "Event-Enable-DiagnoseFirstFailure-By-Conn-Prefix";
    public static final String EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE_BY_CONN_ID_PREFIX = "Event-Disable-DiagnoseFirstFailure-By-Conn-Prefix";
    public static final String EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE_BY_TENANT_NAME = "Event-Enable-DiagnoseFirstFailure-By-Tenant-Name";
    public static final String EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE_BY_TENANT_NAME = "Event-Disable-DiagnoseFirstFailure-By-Tenant-Name";
    public static final String EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE_BY_LOGGER_NAME = "Event-Enable-DiagnoseFirstFailure-By-Logger-Name";
    public static final String EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE_BY_LOGGER_NAME = "Event-Disable-DiagnoseFirstFailure-By-Logger-Name";
    public static final String EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE = "Event-Enable-DiagnoseFirstFailure";
    public static final String EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE = "Event-Disable-DiagnoseFirstFailure";
    public static final String EVENT_ENABLE_LOGGING_BY_CONN_ID_PREFIX = "Event-Enable-Logging-By-Conn-Prefix";
    public static final String EVENT_DISABLE_LOGGING_BY_CONN_ID_PREFIX = "Event-Disable-Logging-By-Conn-Prefix";
    public static final String EVENT_ENABLE_LOGGING_BY_TENANT_NAME = "Event-Enable-Logging-By-Tenant-Name";
    public static final String EVENT_DISABLE_LOGGING_BY_TENANT_NAME = "Event-Disable-Logging-By-Tenant-Name";
    public static final String EVENT_ENABLE_LOGGING_BY_LOGGER_NAME = "Event-Enable-Logging-By-Logger-Name";
    public static final String EVENT_DISABLE_LOGGING_BY_LOGGER_NAME = "Event-Disable-Logging-By-Logger-Name";
    public static final String EVENT_ENABLE_LOGGING = "Event-Enable-Logging";
    public static final String EVENT_DISABLE_LOGGING = "Event-Disable-Logging";
    public static final String EVENT_ENABLE_SENSITIVE_DIAGNOSTICS_BY_CONN_ID_PREFIX = "Event-Enable-Sensitive-Diagnostics-By-Conn-Prefix";
    public static final String EVENT_DISABLE_SENSITIVE_DIAGNOSTICS_BY_CONN_ID_PREFIX = "Event-Disable-Sensitive-Diagnostics-By-Conn-Prefix";
    public static final String EVENT_ENABLE_SENSITIVE_DIAGNOSTICS_BY_TENANT_NAME = "Event-Enable-Sensitive-Diagnostics-By-Tenant-Name";
    public static final String EVENT_DISABLE_SENSITIVE_DIAGNOSTICS_BY_TENANT_NAME = "Event-Disable-Sensitive-Diagnostics-By-Tenant-Name";
    public static final String EVENT_ENABLE_SENSITIVE_DIAGNOSTICS_BY_LOGGER_NAME = "Event-Enable-Sensitive-Diagnostics-By-Logger-Name";
    public static final String EVENT_DISABLE_SENSITIVE_DIAGNOSTICS_BY_LOGGER_NAME = "Event-Disable-Sensitive-Diagnostics-By-Logger-Name";
    public static final String EVENT_ENABLE_SENSITIVE_DIAGNOSTICS = "Event-Enable-Sensitive-Diagnostics";
    public static final String EVENT_DISABLE_SENSITIVE_DIAGNOSTICS = "Event-Disable-Sensitive-Diagnostics";
    public static final String EVENT_UPDATE_DIAGNOSTIC_LEVEL_BY_CONN_ID_PREFIX = "Event-Update-Diagnostic-Level-By-Conn-Prefix";
    public static final String EVENT_UPDATE_DIAGNOSTIC_LEVEL_BY_TENANT_NAME = "Event-Update-Diagnostic-Level-By-Tenant-Name";
    public static final String EVENT_UPDATE_DIAGNOSTIC_LEVEL_BY_LOGGER_NAME = "Event-Update-Diagnostic-Level-By-Logger-Name";
    public static final String EVENT_UPDATE_DIAGNOSTIC_LEVEL = "Event-Update-Diagnostic-Level";
    public static final String EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE_BY_CONN_ID_PREFIX = "Event-Update-DiagnoseFirstFailure-Size-By-Conn-Prefix";
    public static final String EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE_BY_TENANT_NAME = "Event-Update-DiagnoseFirstFailure-Size-By-Tenant-Name";
    public static final String EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE_BY_LOGGER_NAME = "Event-Update-DiagnoseFirstFailure-Size-By-Logger-Name";
    public static final String EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE = "Event-Update-DiagnoseFirstFailure-Size";
    public static final String EVENT_DUMP_DIAGNOSE_FIRST_FAILURE = "Event-Dump-DiagnoseFirstFailure";
    private static final String CLASS_NAME = OracleDiagnosticsMXBean.class.getName();
    private static final Map<PropertyChangeListener, String> WEAK_PROPERTY_CHANGE_SUPPORT = Collections.synchronizedMap(new WeakHashMap());
    private static final Object SOURCE_BEAN = new Object();
    private static final String DUMMY_STRING = "DUMMY";
    private static final int OPERATIONS_LOG_SIZE = 20;
    private static final Queue<String> OPERATIONS_LOG = new LinkedList<String>();

    private OracleDiagnosticsMXBean() {
        super(DiagnosticsMXBean.class, true);
    }

    public static OracleDiagnosticsMXBean getInstance() {
        return INSTANCE;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WEAK_PROPERTY_CHANGE_SUPPORT.put(propertyChangeListener, DUMMY_STRING);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WEAK_PROPERTY_CHANGE_SUPPORT.remove(propertyChangeListener);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        WEAK_PROPERTY_CHANGE_SUPPORT.forEach((k, v) -> k.propertyChange(new PropertyChangeEvent(SOURCE_BEAN, propertyName, oldValue, newValue)));
    }

    private void logOperation(String operationDesc) {
        OPERATIONS_LOG.add(operationDesc);
        if (OPERATIONS_LOG.size() > 20) {
            OPERATIONS_LOG.remove();
        }
    }

    @Override
    public void enableDiagnoseFirstFailureByConnectionIdPrefix(String connectionIdPrefix) {
        this.firePropertyChange(EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE_BY_CONN_ID_PREFIX, null, connectionIdPrefix);
    }

    @Override
    public void disableDiagnoseFirstFailureByConnectionIdPrefix(String connectionIdPrefix) {
        this.firePropertyChange(EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE_BY_CONN_ID_PREFIX, null, connectionIdPrefix);
        this.logOperation("Disabled Diagnose First Failure by connection id prefix : " + connectionIdPrefix);
    }

    @Override
    public void enableDiagnoseFirstFailureByTenantName(String tenantName) {
        this.firePropertyChange(EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE_BY_TENANT_NAME, null, tenantName);
        this.logOperation("Enabled Diagnose First Failure by tenant name : " + tenantName);
    }

    @Override
    public void disableDiagnoseFirstFailureByTenantName(String tenantName) {
        this.firePropertyChange(EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE_BY_TENANT_NAME, null, tenantName);
        this.logOperation("Disabled Diagnose First Failure by tenant name : " + tenantName);
    }

    @Override
    public void enableDiagnoseFirstFailureByLoggerName(String loggerName) {
        this.firePropertyChange(EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE_BY_LOGGER_NAME, null, loggerName);
        this.logOperation("Enabled Diagnose First Failure by logger name : " + loggerName);
    }

    @Override
    public void disableDiagnoseFirstFailureByLoggerName(String loggerName) {
        this.firePropertyChange(EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE_BY_LOGGER_NAME, null, loggerName);
        this.logOperation("Disabled Diagnose First Failure by logger name : " + loggerName);
    }

    @Override
    public void enableDiagnoseFirstFailure() {
        this.firePropertyChange(EVENT_ENABLE_DIAGNOSE_FIRST_FAILURE, null, null);
        this.logOperation("Enabled Diagnose First Failure");
    }

    @Override
    public void disableDiagnoseFirstFailure() {
        this.firePropertyChange(EVENT_DISABLE_DIAGNOSE_FIRST_FAILURE, null, null);
        this.logOperation("Disabled Diagnose First Failure");
    }

    @Override
    public void enableLoggingByConnectionIdPrefix(String connectionIdPrefix) {
        this.firePropertyChange(EVENT_ENABLE_LOGGING_BY_CONN_ID_PREFIX, null, connectionIdPrefix);
        this.logOperation("Enabled logging by connection id prefix : " + connectionIdPrefix);
    }

    @Override
    public void disableLoggingByConnectionIdPrefix(String connectionIdPrefix) {
        this.firePropertyChange(EVENT_DISABLE_LOGGING_BY_CONN_ID_PREFIX, null, connectionIdPrefix);
        this.logOperation("Disabled logging by connection id prefix : " + connectionIdPrefix);
    }

    @Override
    public void enableLoggingByTenantName(String tenantName) {
        this.firePropertyChange(EVENT_ENABLE_LOGGING_BY_TENANT_NAME, null, tenantName);
        this.logOperation("Enabled logging by tenant name : " + tenantName);
    }

    @Override
    public void disableLoggingByTenantName(String tenantName) {
        this.firePropertyChange(EVENT_DISABLE_LOGGING_BY_TENANT_NAME, null, tenantName);
        this.logOperation("Disabled logging by tenant name : " + tenantName);
    }

    @Override
    public void enableLoggingByLoggerName(String loggerName) {
        this.firePropertyChange(EVENT_ENABLE_LOGGING_BY_LOGGER_NAME, null, loggerName);
        this.logOperation("Enabled logging by logger name : " + loggerName);
    }

    @Override
    public void disableLoggingByLoggerName(String loggerName) {
        this.firePropertyChange(EVENT_DISABLE_LOGGING_BY_LOGGER_NAME, null, loggerName);
        this.logOperation("Disabled logging by logger name : " + loggerName);
    }

    @Override
    public void enableLogging() {
        AbstractDiagnosable.enableGlobalDebug(true);
        this.firePropertyChange(EVENT_ENABLE_LOGGING, null, null);
        this.logOperation("Enabled logging");
    }

    @Override
    public void disableLogging() {
        AbstractDiagnosable.enableGlobalDebug(false);
        this.firePropertyChange(EVENT_DISABLE_LOGGING, null, null);
        this.logOperation("Disabled logging");
    }

    @Override
    public boolean isLoggingEnabled() {
        return AbstractDiagnosable.isGlobalDebugEnabled();
    }

    @Override
    public void enableSensitiveDiagnosticsByConnectionIdPrefix(String connectionIdPrefix) {
        this.firePropertyChange(EVENT_ENABLE_SENSITIVE_DIAGNOSTICS_BY_CONN_ID_PREFIX, null, connectionIdPrefix);
        this.logOperation("Enabled sensitive diagnostics by connection id prefix : " + connectionIdPrefix);
    }

    @Override
    public void disableSensitiveDiagnosticsByConnectionIdPrefix(String connectionIdPrefix) {
        this.firePropertyChange(EVENT_DISABLE_SENSITIVE_DIAGNOSTICS_BY_CONN_ID_PREFIX, null, connectionIdPrefix);
        this.logOperation("Disabled sensitive diagnostics by connection id prefix : " + connectionIdPrefix);
    }

    @Override
    public void enableSensitiveDiagnosticsByTenantName(String tenantName) {
        this.firePropertyChange(EVENT_ENABLE_SENSITIVE_DIAGNOSTICS_BY_TENANT_NAME, null, tenantName);
        this.logOperation("Enabled sensitive diagnostics by tenant name : " + tenantName);
    }

    @Override
    public void disableSensitiveDiagnosticsByTenantName(String tenantName) {
        this.firePropertyChange(EVENT_DISABLE_SENSITIVE_DIAGNOSTICS_BY_TENANT_NAME, null, tenantName);
        this.logOperation("Disabled sensitive diagnostics by tenant name : " + tenantName);
    }

    @Override
    public void enableSensitiveDiagnosticsByLoggerName(String loggerName) {
        this.firePropertyChange(EVENT_ENABLE_SENSITIVE_DIAGNOSTICS_BY_LOGGER_NAME, null, loggerName);
        this.logOperation("Enabled sensitive diagnostics by logger name : " + loggerName);
    }

    @Override
    public void disableSensitiveDiagnosticsByLoggerName(String loggerName) {
        this.firePropertyChange(EVENT_DISABLE_SENSITIVE_DIAGNOSTICS_BY_LOGGER_NAME, null, loggerName);
        this.logOperation("Disabled sensitive diagnostics by logger name : " + loggerName);
    }

    @Override
    public void enableSensitiveDiagnostics() {
        this.firePropertyChange(EVENT_ENABLE_SENSITIVE_DIAGNOSTICS, null, null);
        this.logOperation("Enabled sensitive diagnostics");
    }

    @Override
    public void disableSensitiveDiagnostics() {
        this.firePropertyChange(EVENT_DISABLE_SENSITIVE_DIAGNOSTICS, null, null);
        this.logOperation("Disabled sensitive diagnostics");
    }

    @Override
    public void updateDiagnosticLevelByConnectionIdPrefix(String connectionIdPrefix, String loggingLevel) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSTIC_LEVEL_BY_CONN_ID_PREFIX, null, new Object[]{connectionIdPrefix, loggingLevel});
        this.logOperation("Updated diagnostic level by connection id prefix : " + connectionIdPrefix + ", loggingLevel : " + loggingLevel);
    }

    @Override
    public void updateDiagnosticLevelByTenantName(String tenantName, String loggingLevel) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSTIC_LEVEL_BY_TENANT_NAME, null, new Object[]{tenantName, loggingLevel});
        this.logOperation("Updated diagnostic level by tenant name : " + tenantName + ", loggingLevel : " + loggingLevel);
    }

    @Override
    public void updateDiagnosticLevelByLoggerName(String loggerName, String loggingLevel) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSTIC_LEVEL_BY_LOGGER_NAME, null, new Object[]{loggerName, loggingLevel});
        this.logOperation("Updated diagnostic level by logger name : " + loggerName + ", loggingLevel : " + loggingLevel);
    }

    @Override
    public void updateDiagnosticLevel(String loggingLevel) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSTIC_LEVEL, null, loggingLevel);
        this.logOperation("Updated diagnostic level");
    }

    @Override
    public void updateBufferSizeByConnectionIdPrefix(String connectionIdPrefix, Integer bufferSize) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE_BY_CONN_ID_PREFIX, null, new Object[]{connectionIdPrefix, bufferSize});
        this.logOperation("Updated buffer size by connection id prefix : " + connectionIdPrefix + ", buffer size : " + bufferSize);
    }

    @Override
    public void updateBufferSizeByTenantName(String tenantName, Integer bufferSize) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE_BY_TENANT_NAME, null, new Object[]{tenantName, bufferSize});
        this.logOperation("Updated buffer size by tenant name : " + tenantName + ", buffer size : " + bufferSize);
    }

    @Override
    public void updateBufferSizeByLoggerName(String loggerName, Integer bufferSize) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE_BY_LOGGER_NAME, null, new Object[]{loggerName, bufferSize});
        this.logOperation("Updated buffer size by logger name : " + loggerName + ", buffer size : " + bufferSize);
    }

    @Override
    public void updateBufferSize(Integer bufferSize) {
        this.firePropertyChange(EVENT_UPDATE_DIAGNOSE_FIRST_FAILURE_SIZE, null, bufferSize);
        this.logOperation("Updated buffer size");
    }

    @Override
    public void readLoggingConfigFile(String configFile) {
        AbstractDiagnosable.onConfigFileChange(configFile);
        this.logOperation("Read logging config file : " + configFile);
    }

    @Override
    public void addErrorCodeToWatchList(String errorCode) {
        Diagnostic.addErrorCodeToWatchList(errorCode);
        this.logOperation("Added error code to watch list : " + errorCode);
    }

    @Override
    public void removeErrorCodeFromWatchList(String errorCode) {
        Diagnostic.removeErrorCodeFromWatchList(errorCode);
        this.logOperation("Removed error code from watch list : " + errorCode);
    }

    @Override
    public String showErrorCodesWatchList() {
        return Diagnostic.getErrorCodesWatchList();
    }

    @Override
    public void resetErrorCodeWatchList() {
        Diagnostic.resetErrorCodeWatchList();
        this.logOperation("Reset error code watch list");
    }

    @Override
    public void dumpDiagnoseFirstFailure() {
        this.firePropertyChange(EVENT_DUMP_DIAGNOSE_FIRST_FAILURE, null, null);
        this.logOperation("Dumped Diagnose First Failure");
    }

    @Override
    public void dumpDiagnoseFirstFailureWhenFutureExceptionContains(String commaSeparatedKeywords) {
        Diagnostic.dumpDiagnoseFirstFailureWhenNextExceptionContains(commaSeparatedKeywords);
        this.logOperation("Dump Diagnose First Failure when future exception contains : " + commaSeparatedKeywords);
    }

    @Override
    public String showExceptionKeywords() {
        return Diagnostic.getExceptionKeywords();
    }

    @Override
    public String showRecentOperations() {
        return String.join((CharSequence)"\n", OPERATIONS_LOG);
    }

    @Override
    public void clearExceptionKeywords() {
        Diagnostic.clearExceptionKeywords();
        this.logOperation("Cleared exception keywords");
    }

    @Override
    public void enableWriteLogsToDiagnoseFirstFailure(Boolean enabled) {
        AbstractDiagnosable.enableWriteLogsToDiagnoseFirstFailure(enabled);
        this.logOperation("Enabled write logs to Diagnose First Failure");
    }

    @Override
    public boolean isWriteLogsToDiagnoseFirstFailure() {
        return AbstractDiagnosable.isWriteLogsToDiagnoseFirstFailureEnabled();
    }

    @Override
    public void enableMetrics() {
        AbstractDiagnosable.enableMetrics(true);
        this.logOperation("Enabled metrics");
    }

    @Override
    public void disableMetrics() {
        AbstractDiagnosable.enableMetrics(false);
        this.logOperation("Disabled metrics");
    }

    @Override
    public String showMetrics() {
        return Metrics.getReport(TimeUnit.MILLISECONDS);
    }

    @Override
    public void clearMetrics() {
        Metrics.clear();
        this.logOperation("Cleared metrics");
    }

    @Override
    public boolean isMetricsEnabled() {
        return AbstractDiagnosable.isMetricsEnabled();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfos = new MBeanAttributeInfo[]{new MBeanAttributeInfo("LoggingEnabled", Boolean.class.getName(), DatabaseError.findMessage("DiagnosticsMBeanLoggingEnabledAttributeDescription", null), true, false, true), new MBeanAttributeInfo("WriteLogsToDiagnoseFirstFailure", Boolean.class.getName(), DatabaseError.findMessage("DiagnosticsMBeanWriteLogsToDiagnoseFirstFailureAttributeDescription", null), true, false, true), new MBeanAttributeInfo("MetricsEnabled", Boolean.class.getName(), DatabaseError.findMessage("DiagnosticsMBeanMetricsEnabledAttributeDescription", null), true, false, true)};
        MBeanOperationInfo[] mBeanOperationInfos = new MBeanOperationInfo[]{new MBeanOperationInfo("enableDiagnoseFirstFailureByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsMBeanEnableDiagnoseFirstFailureByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableDiagnoseFirstFailureByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsMBeanDisableDiagnoseFirstFailureByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableDiagnoseFirstFailureByTenantName", DatabaseError.findMessage("DiagnosticsMBeanEnableDiagnoseFirstFailureByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableDiagnoseFirstFailureByTenantName", DatabaseError.findMessage("DiagnosticsMBeanDisableDiagnoseFirstFailureByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableDiagnoseFirstFailureByLoggerName", DatabaseError.findMessage("DiagnosticsMBeanEnableDiagnoseFirstFailureByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableDiagnoseFirstFailureByLoggerName", DatabaseError.findMessage("DiagnosticsMBeanDisableDiagnoseFirstFailureByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableDiagnoseFirstFailure", DatabaseError.findMessage("DiagnosticsMBeanEnableDiagnoseFirstFailureOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("disableDiagnoseFirstFailure", DatabaseError.findMessage("DiagnosticsMBeanDisableDiagnoseFirstFailureOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("enableLoggingByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsEnableLoggingByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableLoggingByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsDisableLoggingByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableMetrics", DatabaseError.findMessage("DiagnosticsEnableMetricsOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("disableMetrics", DatabaseError.findMessage("DiagnosticsDisableMetricsOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("showMetrics", DatabaseError.findMessage("DiagnosticsShowMetricsOperationDescription", null), null, String.class.getName(), 1), new MBeanOperationInfo("clearMetrics", DatabaseError.findMessage("DiagnosticsClearMetricsOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("enableLoggingByTenantName", DatabaseError.findMessage("DiagnosticsEnableLoggingByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableLoggingByTenantName", DatabaseError.findMessage("DiagnosticsDisableLoggingByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableLoggingByLoggerName", DatabaseError.findMessage("DiagnosticsEnableLoggingByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableLoggingByLoggerName", DatabaseError.findMessage("DiagnosticsDisableLoggingByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableLogging", DatabaseError.findMessage("DiagnosticsEnableLoggingOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("disableLogging", DatabaseError.findMessage("DiagnosticsDisableLoggingOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("enableSensitiveDiagnosticsByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsEnableSensitiveDiagnosticsByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableSensitiveDiagnosticsByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsDisableSensitiveDiagnosticsByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableSensitiveDiagnosticsByTenantName", DatabaseError.findMessage("DiagnosticsEnableSensitiveDiagnosticsByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableSensitiveDiagnosticsByTenantName", DatabaseError.findMessage("DiagnosticsDisableSensitiveDiagnosticsByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableSensitiveDiagnosticsByLoggerName", DatabaseError.findMessage("DiagnosticsEnableSensitiveDiagnosticsByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("disableSensitiveDiagnosticsByLoggerName", DatabaseError.findMessage("DiagnosticsDisableSensitiveDiagnosticsByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("enableSensitiveDiagnostics", DatabaseError.findMessage("DiagnosticsEnableSensitiveDiagnosticsOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("disableSensitiveDiagnostics", DatabaseError.findMessage("DiagnosticsDisableSensitiveDiagnosticsOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("updateDiagnosticLevelByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsUpdateDiagnosticLevelByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null)), new MBeanParameterInfo("level", String.class.getName(), DatabaseError.findMessage("DiagnosticsLevelParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateDiagnosticLevelByTenantName", DatabaseError.findMessage("DiagnosticsUpdateDiagnosticLevelByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null)), new MBeanParameterInfo("level", String.class.getName(), DatabaseError.findMessage("DiagnosticsLevelParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateDiagnosticLevelByLoggerName", DatabaseError.findMessage("DiagnosticsUpdateDiagnosticLevelByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null)), new MBeanParameterInfo("level", String.class.getName(), DatabaseError.findMessage("DiagnosticsLevelParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateDiagnosticLevel", DatabaseError.findMessage("DiagnosticsUpdateDiagnosticLevelOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("level", String.class.getName(), DatabaseError.findMessage("DiagnosticsLevelParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateBufferSizeByConnectionIdPrefix", DatabaseError.findMessage("DiagnosticsUpdateBufferSizeByConnectionIdPrefixOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("connectionIdPrefix", String.class.getName(), DatabaseError.findMessage("DiagnosticsConnectionIdPrefixParameterDescription", null)), new MBeanParameterInfo("bufferSize", Integer.class.getName(), DatabaseError.findMessage("DiagnosticsBufferSizeParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateBufferSizeByTenantName", DatabaseError.findMessage("DiagnosticsUpdateBufferSizeByTenantNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("tenantName", String.class.getName(), DatabaseError.findMessage("DiagnosticsTenantNameParameterDescription", null)), new MBeanParameterInfo("bufferSize", Integer.class.getName(), DatabaseError.findMessage("DiagnosticsBufferSizeParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateBufferSizeByLoggerName", DatabaseError.findMessage("DiagnosticsUpdateBufferSizeByLoggerNameOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), DatabaseError.findMessage("DiagnosticsLoggerNameParameterDescription", null)), new MBeanParameterInfo("bufferSize", Integer.class.getName(), DatabaseError.findMessage("DiagnosticsBufferSizeParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("updateBufferSize", DatabaseError.findMessage("DiagnosticsUpdateBufferSizeOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("bufferSize", Integer.class.getName(), DatabaseError.findMessage("DiagnosticsBufferSizeParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("readLoggingConfigFile", DatabaseError.findMessage("DiagnosticsReadLoggingConfigFileOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("configFile", String.class.getName(), DatabaseError.findMessage("DiagnosticsConfigFileParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("addErrorCodeToWatchList", DatabaseError.findMessage("DiagnosticsAddErrorCodeToWatchListOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("errorCode", String.class.getName(), DatabaseError.findMessage("DiagnosticsErrorCodesParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("removeErrorCodeFromWatchList", DatabaseError.findMessage("DiagnosticsRemoveErrorCodeFromWatchListOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("errorCode", String.class.getName(), DatabaseError.findMessage("DiagnosticsErrorCodesParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("showErrorCodesWatchList", DatabaseError.findMessage("DiagnosticsShowErrorCodesWatchListOperationDescription", null), null, String.class.getName(), 0), new MBeanOperationInfo("resetErrorCodeWatchList", DatabaseError.findMessage("DiagnosticsResetErrorCodesWatchListOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("dumpDiagnoseFirstFailure", DatabaseError.findMessage("DiagnosticsDumpDiagnoseFirstFailureOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("dumpDiagnoseFirstFailureWhenFutureExceptionContains", DatabaseError.findMessage("DiagnosticsDumpDiagnoseFirstFailureWhenFutureExceptionContainsOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("commaSeparatedKeywords", String.class.getName(), DatabaseError.findMessage("DiagnosticsCommaSeparatedKeywordsParameterDescription", null))}, Void.class.getName(), 1), new MBeanOperationInfo("showExceptionKeywords", DatabaseError.findMessage("DiagnosticsShowExceptionKeywords", null), null, String.class.getName(), 1), new MBeanOperationInfo("showRecentOperations", DatabaseError.findMessage("DiagnosticsShowRecentOperations", null), null, String.class.getName(), 1), new MBeanOperationInfo("clearExceptionKeywords", DatabaseError.findMessage("DiagnosticsClearExceptionKeywordsOperationDescription", null), null, Void.class.getName(), 1), new MBeanOperationInfo("enableWriteLogsToDiagnoseFirstFailure", DatabaseError.findMessage("DiagnosticsEnableWriteLogsToDiagnoseFirstFailureOperationDescription", null), new MBeanParameterInfo[]{new MBeanParameterInfo("enabled", Boolean.class.getName(), DatabaseError.findMessage("DiagnosticsEnabledParameterDescription", null))}, Void.class.getName(), 1)};
        return new MBeanInfo(CLASS_NAME, DatabaseError.findMessage("DiagnosticsMBeanDescription", null), mBeanAttributeInfos, null, mBeanOperationInfos, null);
    }
}

