/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.net.ns.Message;

public class NetErrorMessage
implements Message,
Serializable {
    private static final boolean DEBUG = false;
    private String msg;
    private transient ResourceBundle rBundle;
    private static final String messageFile = "oracle.net.mesg.NetErrorMessages";

    @Override
    public String getMessage(int errorNumber, String userMsg) {
        try {
            this.rBundle = ResourceBundle.getBundle(messageFile);
        }
        catch (Exception e) {
            return "Message file 'oracle.net.mesg.NetErrorMessages' is missing.";
        }
        try {
            String key = String.valueOf(errorNumber);
            this.msg = "ORA-" + key + ": " + this.rBundle.getString(key);
            String _userMsg = userMsg == null || userMsg.trim().isEmpty() ? "" : ": " + userMsg;
            this.msg = this.msg + _userMsg;
        }
        catch (MissingResourceException e) {
            this.msg = userMsg == null || userMsg.trim().isEmpty() ? "ORA-18957: " + this.rBundle.getString(String.valueOf(18957)) + errorNumber : (userMsg.contains(errorNumber + "") ? userMsg : "ORA-" + errorNumber + ": " + userMsg);
        }
        return this.msg;
    }

    @Override
    public String addArgs(String errMsg, Object ... args) {
        errMsg = MessageFormat.format(errMsg, args);
        return errMsg;
    }
}

